/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlLoopVariable
extends RenameableFakePsiElement
implements FtlVariable {
    private final FtlListDirective myDirective;
    private final PsiElement myNameElement;
    private final FtlLoopVariable[] myDependents;
    private final Computable<FtlType> myType;

    protected FtlLoopVariable(@NotNull FtlListDirective directive, @NotNull PsiElement nameElement, boolean withDependents, Computable<FtlType> type) {
        FtlLoopVariable[] ftlLoopVariableArray;
        if (directive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "<init>"));
        }
        if (nameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameElement", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "<init>"));
        }
        super((PsiElement)directive);
        this.myDirective = directive;
        this.myNameElement = nameElement;
        if (withDependents) {
            FtlLoopVariable[] ftlLoopVariableArray2 = new FtlLoopVariable[2];
            ftlLoopVariableArray2[0] = this.createDependent((PsiType)PsiType.BOOLEAN, "_has_next");
            ftlLoopVariableArray = ftlLoopVariableArray2;
            ftlLoopVariableArray2[1] = this.createDependent((PsiType)PsiType.INT, "_index");
        } else {
            ftlLoopVariableArray = new FtlLoopVariable[]{};
        }
        this.myDependents = ftlLoopVariableArray;
        this.myType = type;
    }

    @NotNull
    private FtlLoopVariable createDependent(PsiType varType, final String suffix) {
        FtlLoopVariable ftlLoopVariable = new FtlLoopVariable(this.myDirective, this.myNameElement, false, () -> FtlPsiType.wrap(varType)){

            @Override
            @NotNull
            public FtlLoopVariable getMainVariable() {
                FtlLoopVariable ftlLoopVariable = FtlLoopVariable.this;
                if (ftlLoopVariable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable$1", "getMainVariable"));
                }
                return ftlLoopVariable;
            }

            @Override
            @NotNull
            public String getSuffix() {
                String string = suffix;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable$1", "getSuffix"));
                }
                return string;
            }

            @Override
            public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlLoopVariable$1", "setName"));
                }
                return this;
            }
        };
        if (ftlLoopVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "createDependent"));
        }
        return ftlLoopVariable;
    }

    @NotNull
    public FtlLoopVariable getMainVariable() {
        FtlLoopVariable ftlLoopVariable = this;
        if (ftlLoopVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getMainVariable"));
        }
        return ftlLoopVariable;
    }

    public FtlLoopVariable[] getDependents() {
        return this.myDependents;
    }

    public FtlLoopVariable[] uniteWithDependents() {
        FtlLoopVariable[] ftlLoopVariableArray;
        if (this.myDependents.length == 0) {
            FtlLoopVariable[] ftlLoopVariableArray2 = new FtlLoopVariable[1];
            ftlLoopVariableArray = ftlLoopVariableArray2;
            ftlLoopVariableArray2[0] = this;
        } else {
            ftlLoopVariableArray = (FtlLoopVariable[])ArrayUtil.append((Object[])this.myDependents, (Object)this);
        }
        return ftlLoopVariableArray;
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.myDirective);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getUseScope"));
        }
        return localSearchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myNameElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    public FtlListDirective getDirective() {
        return this.myDirective;
    }

    @NotNull
    public String getSuffix() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getSuffix"));
        }
        return "";
    }

    @NotNull
    public String getName() {
        String string = this.myNameElement.getText() + this.getSuffix();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "setName"));
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<#list a as " + name + ">", this.getProject());
        FtlListDirective directive = (FtlListDirective)tag.getSubDirectives()[0];
        this.myDirective.getNode().replaceChild(this.myNameElement.getNode(), directive.getNameElements().get(0).getNode());
        return this;
    }

    public PsiElement getParent() {
        return this.myDirective;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    @Nullable
    public FtlType getType() {
        return (FtlType)this.myType.compute();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlLoopVariable)) {
            return false;
        }
        FtlLoopVariable variable = (FtlLoopVariable)o;
        return this.myNameElement == variable.myNameElement && this.getSuffix().equals(variable.getSuffix());
    }

    public int hashCode() {
        return Objects.hash(this.myNameElement, this.getSuffix());
    }
}

