/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlEscapeDirective
extends FtlDirective
implements FtlVariable {
    public FtlEscapeDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    public PsiElement getNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    public String getName() {
        PsiElement element = this.getNameElement();
        return element == null ? null : element.getText();
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Nullable
    public FtlExpression getExpression() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlEscapeDirective", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlEscapeDirective", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlEscapeDirective", "processDeclarations"));
        }
        if (lastParent == this.getExpression() && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlEscapeDirective", "setName"));
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<#escape " + name + ">", this.getProject());
        FtlEscapeDirective directive = (FtlEscapeDirective)tag.getSubDirectives()[0];
        this.getNode().replaceChild(this.getNameElement().getNode(), directive.getNameElement().getNode());
        return this;
    }

    @Override
    public FtlType getType() {
        return null;
    }
}

