/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.freemarker.psi.FtlCallableLookupElement;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FtlElementCellRenderer
extends PsiElementListCellRenderer<FtlVariable>
implements GotoTargetRendererProvider {
    public String getElementText(FtlVariable element) {
        String name = StringUtil.notNullize((String)element.getName());
        FtlCallableType type = FtlPsiUtil.asInstanceOf(element.getType(), FtlCallableType.class);
        if (type != null) {
            return name + FtlCallableLookupElement.getSignature(type);
        }
        return name;
    }

    protected String getContainerText(FtlVariable element, String name) {
        return "   (" + element.getContainingFile().getName() + ")";
    }

    protected int getIconFlags() {
        return 0;
    }

    protected Icon getIcon(PsiElement element) {
        FtlCallableType type = FtlPsiUtil.asInstanceOf(((FtlVariable)element).getType(), FtlCallableType.class);
        if (type != null) {
            return FtlCallableLookupElement.getCallableIcon(type, false);
        }
        return super.getIcon(element);
    }

    public PsiElementListCellRenderer getRenderer(@NotNull PsiElement element, @NotNull GotoTargetHandler.GotoData gotoData) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlElementCellRenderer", "getRenderer"));
        }
        if (gotoData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/freemarker/psi/directives/FtlElementCellRenderer", "getRenderer"));
        }
        if (element instanceof FtlVariable) {
            return this;
        }
        return null;
    }
}

