/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.SimpleMethodCallLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlAssignmentNamespace;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCallableLookupElement;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlVariantsProcessor;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlImportDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlDynamicMember;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlQualifiedReference
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    public static final Key<Boolean> RESOLVING_MACRO = Key.create((String)"RESOLVING_MACRO");
    private static final ResolveCache.PolyVariantResolver<FtlQualifiedReference> MY_RESOLVER = new ResolveCache.PolyVariantResolver<FtlQualifiedReference>(){

        @NotNull
        public FtlResolveResult[] resolve(@NotNull FtlQualifiedReference expression, boolean incompleteCode) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/freemarker/psi/FtlQualifiedReference$1", "resolve"));
            }
            FtlResolveResult[] ftlResolveResultArray = expression.resolveInner();
            if (ftlResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference$1", "resolve"));
            }
            return ftlResolveResultArray;
        }
    };
    private final FtlReferenceQualifier myElement;
    @NonNls
    private static final Pattern NODE_CHILDREN_PATTERN = Pattern.compile("[@\\*]?(\\w*)(\\:(\\w*))?");

    protected FtlQualifiedReference(FtlReferenceQualifier element) {
        this.myElement = element;
    }

    @NotNull
    public FtlExpression getElement() {
        FtlReferenceQualifier ftlReferenceQualifier = this.myElement;
        if (ftlReferenceQualifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "getElement"));
        }
        return ftlReferenceQualifier;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "getCanonicalText"));
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    public FtlQualifiedReference getParentReference() {
        PsiElement parent = this.getValidExpression().getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof FtlIndexExpression && this == ((FtlIndexExpression)parent).getQualifiedReference()) {
            return null;
        }
        return FtlPsiUtil.getReference(parent);
    }

    public PsiElement handleElementRename(String newText) throws IncorrectOperationException {
        String propertyName;
        PsiElement target;
        CheckUtil.checkWritable((PsiElement)this.myElement);
        if (!this.isCall() && ((target = this.resolve()) instanceof PsiMethod || target instanceof FtlDynamicMember) && (propertyName = PropertyUtil.getPropertyName((String)newText)) != null) {
            newText = propertyName;
        }
        return this.doHandleElementRename(newText);
    }

    protected abstract PsiElement doHandleElementRename(String var1) throws IncorrectOperationException;

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/FtlQualifiedReference", "bindToElement"));
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this.myElement;
    }

    @Nullable
    public abstract String getReferenceName();

    @Nullable
    public FtlAssignmentDeclaration getAssignDeclaration() {
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof FtlNameValuePair) {
            FtlNameValuePair nameValuePair = (FtlNameValuePair)parent;
            FtlTokenType token = nameValuePair.getOperationToken();
            if (token != null && token != FtlElementTypes.EQ) {
                return null;
            }
            if (nameValuePair.getNameElement() == this.myElement && parent.getParent() instanceof FtlAssignDirective) {
                return ((FtlAssignDirective)parent.getParent()).getDeclarationFor(nameValuePair);
            }
        }
        return null;
    }

    @NotNull
    protected FtlResolveResult[] resolveInner() {
        FtlParameterDeclaration varargParameter;
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (FtlResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "resolveInner"));
            }
            return FtlResolveResult.EMPTY_ARRAY;
        }
        FtlVariantsProcessor<FtlResolveResult> processor = new FtlVariantsProcessor<FtlResolveResult>(this, referenceName){

            @Override
            protected FtlResolveResult execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                if (element instanceof BeanPropertyElement) {
                    return new FtlResolveResult((PsiNamedElement)((BeanPropertyElement)element).getMethod(), error, substitutor);
                }
                return new FtlResolveResult(element, error, substitutor);
            }
        };
        FtlAssignmentDeclaration assignmentDeclaration = this.getAssignDeclaration();
        if (assignmentDeclaration != null) {
            processor.execute((PsiElement)assignmentDeclaration, this.initialState());
        }
        this.processVariantsInner((PsiScopeProcessor)processor, false, this.initialState());
        FtlResolveResult[] results = processor.toArray(FtlResolveResult.EMPTY_ARRAY);
        if (results.length == 0 && (varargParameter = this.getVarargParameter()) != null) {
            FtlResolveResult[] ftlResolveResultArray = new FtlResolveResult[]{new FtlResolveResult(varargParameter, JavaMethodResolveHelper.ErrorType.NONE, PsiSubstitutor.EMPTY)};
            if (ftlResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "resolveInner"));
            }
            return ftlResolveResultArray;
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "resolveInner"));
        }
        return results;
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        FtlFile file = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false, (PsiFile)file);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public final PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        if (results.length == 1) {
            return results[0].getElement();
        }
        FtlImplicitVariable implicit = null;
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!(element instanceof FtlVariable)) {
                return null;
            }
            if (!(element instanceof FtlImplicitVariable)) continue;
            if (implicit != null) {
                return null;
            }
            implicit = (FtlImplicitVariable)element;
        }
        return implicit;
    }

    @NotNull
    public Object[] getVariants() {
        FtlVariantsProcessor<PsiNamedElement> processor = new FtlVariantsProcessor<PsiNamedElement>(this, null){

            @Override
            protected PsiNamedElement execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                return element;
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor, true, this.initialState());
        final boolean isMacroParameter = this.isMacroParameter(true);
        Object[] elements = processor.toArray(PsiNamedElement.EMPTY_ARRAY);
        Object[] objectArray = ContainerUtil.map2Array((Object[])elements, LookupElement.class, (Function)new Function<PsiNamedElement, LookupElement>(){

            public LookupElement fun(PsiNamedElement element) {
                PsiType type;
                FtlVariable variable;
                FtlCallableType type2;
                if (element instanceof PsiMethod) {
                    return new SimpleMethodCallLookupElement((PsiMethod)element);
                }
                if (element instanceof FtlVariable && (type2 = FtlPsiUtil.asInstanceOf((variable = (FtlVariable)element).getType(), FtlCallableType.class)) != null) {
                    String name = variable.getName();
                    assert (name != null);
                    return new FtlCallableLookupElement(name, type2, false){

                        @Override
                        public void handleInsert(InsertionContext context) {
                            if (type2.isMacro() && isMacroParameter) {
                                if (context.getCompletionChar() == ' ') {
                                    context.setAddCompletionChar(false);
                                }
                                TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)' ');
                            } else {
                                super.handleInsert(context);
                            }
                        }
                    };
                }
                String name = element.getName();
                assert (name != null);
                String lookupString = name;
                if (!FtlPsiUtil.isValidVariableName(name) && FtlQualifiedReference.this.myElement instanceof FtlReferenceExpression) {
                    String quoted = "['" + name + "']";
                    lookupString = FtlQualifiedReference.this.getReferenceQualifier() == null ? ".vars" + quoted : quoted;
                }
                LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)element, (String)lookupString);
                lookupElement = lookupElement.withLookupString(name).withIcon(element.getIcon(0));
                if (element instanceof FtlVariable) {
                    FtlType type3 = ((FtlVariable)element).getType();
                    if (type3 != null) {
                        lookupElement = lookupElement.withTypeText(type3.getPresentableText());
                    }
                } else if (element instanceof BeanPropertyElement && (type = ((BeanPropertyElement)element).getPropertyType()) != null) {
                    lookupElement = lookupElement.withTypeText(type.getPresentableText());
                }
                if (element instanceof FtlParameterDeclaration && isMacroParameter) {
                    return TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)new CharTailType('='));
                }
                if (element instanceof FtlImportDirective && !(FtlQualifiedReference.this.myElement.getParent() instanceof FtlAssignmentNamespace)) {
                    return TailTypeDecorator.withTail((LookupElement)lookupElement, (TailType)TailType.DOT);
                }
                return lookupElement;
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isMacroParameter(boolean forCompletion) {
        return this.getMacroReference(forCompletion) != null;
    }

    @Nullable
    private FtlCallableType getMacroType(boolean forCompletion) {
        FtlCallableType type;
        FtlExpression expression;
        if (this.getReferenceQualifier() == null && (expression = this.getMacroReference(forCompletion)) != null && (type = FtlPsiUtil.asInstanceOf(expression.getType(), FtlCallableType.class)) != null && type.isMacro()) {
            return type;
        }
        return null;
    }

    @Nullable
    private FtlParameterDeclaration getVarargParameter() {
        FtlCallableType macroType = this.getMacroType(false);
        return macroType != null ? macroType.getVarargParameter() : null;
    }

    protected void processVariantsInner(PsiScopeProcessor processor, boolean forCompletion, ResolveState state) {
        PsiElement psiElement;
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            FtlCallableType type = this.getMacroType(forCompletion);
            if (type != null) {
                boolean onlyMacroParam;
                THashSet definedParameters = new THashSet();
                PsiElement parent = this.myElement.getParent();
                boolean bl = onlyMacroParam = forCompletion && parent instanceof FtlNameValuePair;
                if (onlyMacroParam) {
                    FtlNameValuePair pair;
                    FtlArgumentList list = (FtlArgumentList)parent.getParent();
                    FtlNameValuePair[] ftlNameValuePairArray = list.getNamedArguments();
                    int n = ftlNameValuePairArray.length;
                    for (int i = 0; i < n && (pair = ftlNameValuePairArray[i]) != parent; ++i) {
                        definedParameters.add(pair.getName());
                    }
                }
                for (FtlParameter variable : type.getParameters()) {
                    if (definedParameters.contains(variable.getName()) || processor.execute((PsiElement)variable, state)) continue;
                    return;
                }
                if (onlyMacroParam) {
                    return;
                }
            }
            PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, null, (ResolveState)this.initialState());
            return;
        }
        FtlType type = qualifier.getType();
        if (type != null && !type.processDeclarations(processor, this.myElement, state)) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference instanceof FtlQualifiedReference && (psiElement = reference.resolve()) != null && !psiElement.processDeclarations(processor, state, null, (PsiElement)this.myElement)) {
            return;
        }
    }

    @Nullable
    private FtlExpression getMacroReference(boolean forCompletion) {
        FtlArgumentList list;
        FtlNameValuePair nameValuePair;
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof FtlNameValuePair && (nameValuePair = (FtlNameValuePair)parent).getNameElement() == this.myElement && parent.getParent() instanceof FtlArgumentList && parent.getParent().getParent() instanceof FtlMacro) {
            return ((FtlMacro)parent.getParent().getParent()).getMacroReference();
        }
        if (forCompletion && parent instanceof FtlArgumentList && (list = (FtlArgumentList)parent).isPositional() && list.getPositionalArguments()[0] == this.myElement && parent.getParent() instanceof FtlMacro) {
            return ((FtlMacro)parent.getParent()).getMacroReference();
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        PsiManager manager = this.myElement.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (manager.areElementsEquivalent(element, target)) {
                return true;
            }
            if (target instanceof BeanPropertyElement && manager.areElementsEquivalent(element, (PsiElement)((BeanPropertyElement)target).getMethod())) {
                return true;
            }
            if (!(target instanceof FtlDynamicMember) || !manager.areElementsEquivalent(element, (PsiElement)((FtlDynamicMember)target).getDeclaration())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public abstract FtlReferenceQualifier getReferenceQualifier();

    public LocalQuickFix[] getQuickFixes() {
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ResolveResult[] results = this.multiResolve(false);
        if (results.length != 1) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ResolveResult resolveResult = results[0];
        if (!(resolveResult instanceof FtlResolveResult)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlResolveResult result = (FtlResolveResult)resolveResult;
        if (result.getResolveError() != JavaMethodResolveHelper.ErrorType.STATIC) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlPsiType type = FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlPsiType.class);
        if (type == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        FtlQualifiedReference reference = FtlPsiUtil.getReference(qualifier);
        if (reference == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        final PsiElement var = reference.resolve();
        if (!(var instanceof FtlImplicitVariable)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = FreeMarkerBundle.message("quickfix.convert.to.instance", ((FtlImplicitVariable)var).getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference$5", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/psi/FtlQualifiedReference$5", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/freemarker/psi/FtlQualifiedReference$5", "applyFix"));
                }
                if (!var.isValid()) {
                    return;
                }
                PsiElement comment = var.getNavigationElement();
                if (!comment.isValid()) {
                    return;
                }
                int offset = FtlReferenceContributor.getTypeEndOffset(comment.getText());
                if (offset < 0) {
                    return;
                }
                offset += comment.getTextRange().getStartOffset();
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(comment.getContainingFile());
                assert (document != null);
                if (!StringUtil.endsWith((CharSequence)document.getCharsSequence().subSequence(0, offset), (CharSequence)".static")) {
                    return;
                }
                document.deleteString(offset - ".static".length(), offset);
            }
        }};
    }

    @Nullable
    private String getStaticErrorMessage() {
        PsiElement element = this.resolve();
        if (element instanceof PsiMember) {
            return FreeMarkerBundle.message("error.static.member.expected", new Object[0]);
        }
        return null;
    }

    public String getUnresolvedMessage(JavaMethodResolveHelper.ErrorType resolveError) {
        String referenceName = this.getReferenceName();
        if (this.myElement.getParent() instanceof FtlMacro) {
            return FreeMarkerBundle.message("error.cannot.resolve.macro", referenceName);
        }
        FtlExpression expression = this.getMacroReference(false);
        if (expression != null) {
            return FreeMarkerBundle.message("error.cannot.resolve.parameter.0.of.macro.1", referenceName, expression.getText());
        }
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        boolean isCall = this.isCall();
        if (qualifier != null) {
            PsiClass type = FtlPsiUtil.resolveClassInType(qualifier.getType());
            if (type != null) {
                String message;
                String typeName = type.getQualifiedName();
                if (isCall) {
                    switch (resolveError) {
                        case RESOLVE: {
                            Ref containsNulls = Ref.create((Object)false);
                            String s = StringUtil.join((Object[])((FtlMethodCallExpression)this.myElement.getParent()).getArgumentTypes(), psiType -> {
                                if (psiType == null) {
                                    containsNulls.set((Object)true);
                                    return "???";
                                }
                                return psiType.getPresentableText();
                            }, (String)", ");
                            if (((Boolean)containsNulls.get()).booleanValue()) {
                                return FreeMarkerBundle.message("error.multiple.overloaded.methods", referenceName + "(" + s + ")");
                            }
                            return FreeMarkerBundle.message("error.no.applicable.method", referenceName, typeName, "(" + s + ")");
                        }
                        case STATIC: {
                            String message2 = this.getStaticErrorMessage();
                            if (message2 != null) {
                                return message2;
                            }
                        }
                        case NONE: {
                            return FreeMarkerBundle.message("error.cannot.resolve.method.of", referenceName, typeName);
                        }
                    }
                }
                if (resolveError == JavaMethodResolveHelper.ErrorType.STATIC && (message = this.getStaticErrorMessage()) != null) {
                    return message;
                }
                return FreeMarkerBundle.message("error.cannot.resolve.field.of", referenceName, typeName);
            }
            if (qualifier.getType() == null) {
                if (isCall) {
                    return FreeMarkerBundle.message("error.cannot.resolve.method", referenceName);
                }
                return FreeMarkerBundle.message("error.cannot.resolve.field", referenceName);
            }
        }
        if (isCall) {
            return FreeMarkerBundle.message("error.cannot.resolve.function.0", referenceName);
        }
        if (resolveError == JavaMethodResolveHelper.ErrorType.RESOLVE) {
            return FreeMarkerBundle.message("variable.may.be.undefined", referenceName);
        }
        return FreeMarkerBundle.message("error.cannot.resolve.variable.0", referenceName);
    }

    public boolean isCall() {
        return this.getExpressionParent() instanceof FtlMethodCallExpression;
    }

    @Nullable
    public FtlType getType() {
        if (this.isNodeChildrenAccessor()) {
            return new FtlCollectionType(FtlNodeType.INSTANCE);
        }
        LinkedHashSet types = ContainerUtil.newLinkedHashSet();
        for (ResolveResult result : this.multiResolve(false)) {
            FtlReferenceQualifier qualifier;
            PsiMethod method;
            PsiSubstitutor substitutor = ((FtlResolveResult)result).getSubstitutor();
            PsiElement element = result.getElement();
            if (element instanceof PsiMethod && "clone".equals((method = (PsiMethod)element).getName()) && method.getParameterList().getParametersCount() == 0 && (qualifier = this.getReferenceQualifier()) != null) {
                types.add(qualifier.getType());
                continue;
            }
            for (FtlType type : FtlPsiUtil.getAllTypeComponents(FtlPsiUtil.getFtlTypeByPsiElement(element, substitutor), FtlType.class)) {
                FtlCallableType callableType;
                if (!this.isCall() && type instanceof FtlCallableType && !(callableType = (FtlCallableType)type).isMacro()) {
                    type = callableType.getResultType();
                }
                types.add(type);
            }
            if (!(element instanceof FtlLoopVariable) || !((FtlLoopVariable)element).getSuffix().isEmpty() || !(this.getExpressionParent() instanceof FtlBuiltIn)) continue;
            types.add(FtlLoopVariableType.INSTANCE);
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            return (FtlType)types.iterator().next();
        }
        return new FtlCompositeType(types.toArray(new FtlType[types.size()]));
    }

    public FtlCallableType[] getCallableCandidates() {
        final String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return FtlCallableType.EMPTY_ARRAY;
        }
        FtlVariantsProcessor<FtlCallableType> processor = new FtlVariantsProcessor<FtlCallableType>(this, null){

            @Override
            protected FtlCallableType execute(PsiNamedElement element, JavaMethodResolveHelper.ErrorType error, PsiSubstitutor substitutor) {
                if (!referenceName.equals(element.getName())) {
                    return null;
                }
                if (element instanceof PsiMethod) {
                    return new FtlMethodType((PsiMethod)element, substitutor);
                }
                if (element instanceof FtlSignatureDirective) {
                    return ((FtlSignatureDirective)element).getType();
                }
                return null;
            }
        };
        this.processVariantsInner((PsiScopeProcessor)processor, false, this.initialState());
        return processor.toArray(FtlCallableType.EMPTY_ARRAY);
    }

    private ResolveState initialState() {
        return ResolveState.initial().put(RESOLVING_MACRO, (Object)FtlQualifiedReference.isMacroCall(this.myElement));
    }

    private static boolean isMacroCall(PsiElement place) {
        FtlMacro macro = (FtlMacro)PsiTreeUtil.getParentOfType((PsiElement)place, FtlMacro.class);
        return macro != null && PsiTreeUtil.isAncestor((PsiElement)macro.getMacroReference(), (PsiElement)place, (boolean)false);
    }

    public boolean isNodeChildrenAccessor() {
        FtlReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            return false;
        }
        if (FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlNodeType.class) == null) {
            return false;
        }
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        if ("*".equals(referenceName) || "**".equals(referenceName) || "@@".equals(referenceName) || "@*".equals(referenceName)) {
            return true;
        }
        if (referenceName.startsWith("@@")) {
            return false;
        }
        return NODE_CHILDREN_PATTERN.matcher(referenceName).matches();
    }

    public PsiElement getExpressionParent() {
        return this.myElement.getParent();
    }

    @NotNull
    public FtlExpression getValidExpression() {
        if (this.isCall()) {
            FtlExpression ftlExpression = (FtlExpression)this.getExpressionParent();
            if (ftlExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "getValidExpression"));
            }
            return ftlExpression;
        }
        FtlReferenceQualifier ftlReferenceQualifier = this.myElement;
        if (ftlReferenceQualifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlQualifiedReference", "getValidExpression"));
        }
        return ftlReferenceQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlQualifiedReference)) {
            return false;
        }
        FtlQualifiedReference that = (FtlQualifiedReference)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }
}

