/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class FtlMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public FtlMethodUsageSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/freemarker/psi/FtlMethodUsageSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/freemarker/psi/FtlMethodUsageSearcher", "processQuery"));
        }
        PsiMethod method = queryParameters.getMethod();
        PsiFile containingFile = method.getContainingFile();
        PsiClass psiClass = method.getContainingClass();
        if (containingFile == null || psiClass == null) {
            return;
        }
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (!(fileViewProvider instanceof FtlFileViewProvider)) {
            return;
        }
        FtlFile ftlFile = (FtlFile)fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        if (ftlFile == null || !ftlFile.isImplicitlyIncluded()) {
            return;
        }
        if (!PropertyUtil.hasGetterName((PsiMethod)method) || method.getParameterList().getParametersCount() != 1) {
            return;
        }
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope restrictedScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{FtlFileType.INSTANCE});
            String propName = PropertyUtil.getPropertyNameByGetter((PsiMethod)method);
            queryParameters.getOptimizer().searchWord(propName, (SearchScope)restrictedScope, (short)8, true, (PsiElement)method, (RequestResultProcessor)new MethodTextOccurrenceProcessor(psiClass, true, new PsiMethod[]{method}));
        }
    }
}

