/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class FtlXmlSuppressionProvider
extends XmlSuppressionProvider {
    public boolean isProviderAvailable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "isProviderAvailable"));
        }
        return !(file instanceof FtlFile) && file.getViewProvider() instanceof FtlFileViewProvider;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "isSuppressedFor"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "isSuppressedFor"));
        }
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        PsiElement ftlLeaf = viewProvider.findElementAt(element.getTextRange().getStartOffset(), viewProvider.getBaseLanguage());
        return ftlLeaf != null && FtlSuppressableInspection.getCommentFor(ftlLeaf, inspectionId) != null;
    }

    public void suppressForFile(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "suppressForFile"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "suppressForFile"));
        }
        new DefaultXmlSuppressionProvider().suppressForFile(element, inspectionId);
    }

    public void suppressForTag(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "suppressForTag"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/freemarker/inspections/FtlXmlSuppressionProvider", "suppressForTag"));
        }
        FtlSuppressableInspection.suppressForElement(element, inspectionId);
    }
}

