/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlErrorFilter", "shouldHighlightErrorElement"));
        }
        return FtlErrorFilter.shouldHighlightErrorsInFile(element.getContainingFile());
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/freemarker/inspections/FtlErrorFilter", "accept"));
        }
        return highlightInfo.getSeverity() != HighlightSeverity.ERROR || FtlErrorFilter.shouldHighlightErrorsInFile(file);
    }

    private static boolean shouldHighlightErrorsInFile(PsiFile file) {
        if (file == null) {
            return true;
        }
        return !(file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file)).getViewProvider().getBaseLanguage().isKindOf((Language)FtlLanguage.INSTANCE) || file instanceof FtlFile;
    }
}

