/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import icons.FreemarkerIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromUsageIntentionBase {
    protected void chooseTargetFile(final PsiFile file, final Editor editor) {
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        Collection<FtlFile> files = FtlFile.getImplicitlyIncludedFiles(module);
        if (files.size() == 1) {
            this.addDeclaration(file, editor, (PsiFile)files.iterator().next());
            return;
        }
        if (files.size() > 1) {
            BaseListPopupStep<FtlFile> step = new BaseListPopupStep<FtlFile>(FreeMarkerBundle.message("choose.external.definitions.file", new Object[0]), files.toArray(new FtlFile[files.size()])){

                @NotNull
                public String getTextFor(FtlFile value) {
                    String string = value.getViewProvider().getVirtualFile().getName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase$1", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(FtlFile selectedValue, boolean finalChoice) {
                    if (finalChoice) {
                        CreateFromUsageIntentionBase.this.addDeclaration(file, editor, (PsiFile)selectedValue);
                    }
                    return super.onChosen((Object)selectedValue, finalChoice);
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public Icon getIconFor(FtlFile aValue) {
                    return FreemarkerIcons.Freemarker_icon;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
            return;
        }
        FtlFile newTargetFile = (FtlFile)((Object)new WriteCommandAction<FtlFile>(file.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<FtlFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase$2", "run"));
                }
                VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                if (roots.length == 0) {
                    roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                }
                assert (roots.length > 0);
                VirtualFile root = roots[0];
                String fileName = "freemarker_implicit.ftl";
                if (root.findChild(fileName) != null) {
                    String candidate;
                    int i = 2;
                    while (root.findChild(candidate = "freemarker_implicit" + i + ".ftl") != null) {
                        ++i;
                    }
                    fileName = candidate;
                }
                VirtualFile virtualFile = root.createChildData((Object)this, fileName);
                VfsUtil.saveText((VirtualFile)virtualFile, (String)"[#ftl]\n[#-- @implicitly included --]\n");
                PsiFile psiFile = file.getManager().findFile(virtualFile);
                if (psiFile instanceof FtlFile) {
                    result.setResult((Object)((FtlFile)psiFile));
                }
            }
        }.execute().getResultObject());
        if (newTargetFile != null) {
            this.addDeclaration(file, editor, (PsiFile)newTargetFile);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected final void addDeclaration(@NotNull PsiFile sourceFile, final @NotNull Editor sourceEditor, @NotNull PsiFile targetFile) {
        Editor editor;
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase", "addDeclaration"));
        }
        if (sourceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditor", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase", "addDeclaration"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase", "addDeclaration"));
        }
        final Project project = targetFile.getProject();
        final VirtualFile sourceVFile = sourceFile.getViewProvider().getVirtualFile();
        final VirtualFile targetVFile = targetFile.getViewProvider().getVirtualFile();
        Editor editor2 = editor = sourceFile == targetFile ? sourceEditor : FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, targetVFile, 0), true);
        if (editor == null) {
            return;
        }
        new WriteCommandAction(project, new PsiFile[]{targetFile}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/inspections/CreateFromUsageIntentionBase$3", "run"));
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                PsiFile sourceFile = psiManager.findFile(sourceVFile);
                PsiFile targetFile = psiManager.findFile(targetVFile);
                if (sourceFile == null || targetFile == null) {
                    return;
                }
                CreateFromUsageIntentionBase.this.addDeclaration(sourceFile, sourceEditor, targetFile, editor);
            }
        }.execute();
    }

    protected abstract void addDeclaration(PsiFile var1, Editor var2, PsiFile var3, Editor var4) throws IncorrectOperationException;

    @Nullable
    public static FtlQualifiedReference findQualifiedReference(Editor editor, PsiFile file) {
        PsiReference reference = file.findReferenceAt(CreateFromUsageIntentionBase.getAdjustedCaretOffset(editor));
        return reference instanceof FtlQualifiedReference ? (FtlQualifiedReference)reference : null;
    }

    protected static int getAdjustedCaretOffset(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        if (charSequence.length() > offset && !Character.isJavaIdentifierPart(charSequence.charAt(offset))) {
            --offset;
        }
        return offset;
    }

    protected static void prepareInsertionPlace(PsiFile sourceFile, PsiFile targetFile, Editor editor) {
        if (sourceFile == targetFile) {
            int i;
            editor.getSelectionModel().removeSelection();
            FtlQualifiedReference reference = CreateFromUsageIntentionBase.findQualifiedReference(editor, sourceFile);
            assert (reference != null);
            FtlCompositeElement top = (FtlCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), (Class[])new Class[]{FtlInterpolation.class, FtlXmlTag.class});
            assert (top != null);
            PsiElement element = top.getPrevSibling();
            editor.getCaretModel().moveToOffset(top.getTextRange().getStartOffset());
            LogicalPosition position = editor.getCaretModel().getLogicalPosition();
            int enterOffset = element != null && element.getNode().getElementType() == FtlElementTypes.TEMPLATE_TEXT ? ((i = element.getText().lastIndexOf(10)) < 0 ? element.getTextRange().getStartOffset() : element.getTextRange().getStartOffset() + i + 1) : top.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(enterOffset);
            CreateFromUsageIntentionBase.doEnter(editor);
            CreateFromUsageIntentionBase.doEnter(editor);
            editor.getCaretModel().moveToLogicalPosition(position);
            int virtualSpaceLength = position.column - editor.getCaretModel().getLogicalPosition().column;
            if (virtualSpaceLength > 0) {
                String virtualSpace = EditorModificationUtil.calcStringToFillVirtualSpace((Editor)editor, (int)virtualSpaceLength);
                editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)virtualSpace);
                editor.getCaretModel().moveToLogicalPosition(position);
            }
        } else {
            int offset = editor.getDocument().getTextLength();
            offset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)offset, (String)" \t\n");
            if (offset < 0) {
                offset = 0;
            }
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().setSelection(offset, editor.getDocument().getTextLength());
            if (!((FtlFile)targetFile).isImplicitlyIncluded()) {
                CreateFromUsageIntentionBase.doEnter(editor);
            }
            CreateFromUsageIntentionBase.doEnter(editor);
        }
    }

    private static void doEnter(Editor sourceEditor) {
        DataContext dataContext = DataManager.getInstance().getDataContext();
        EditorActionHandler enterHander = EditorActionManager.getInstance().getActionHandler("EditorEnter");
        enterHander.execute(sourceEditor, dataContext);
    }
}

