/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.files.FtlSyntaxHighlighter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.FreemarkerIcons;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlColorSettingsPage
implements ColorSettingsPage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.freemarker.FtlColorSettingsPage");

    @Nullable
    public Icon getIcon() {
        return FreemarkerIcons.Freemarker_icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        FtlSyntaxHighlighter ftlSyntaxHighlighter = new FtlSyntaxHighlighter();
        if (ftlSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlColorSettingsPage", "getHighlighter"));
        }
        return ftlSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("[#if group.userCount()>settings.minUserCount]\n[/#if]\n[#foreach v in [1,'2']]\n  ${v}[/#foreach]\n[#-- comment --]" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlColorSettingsPage", "getDemoText"));
        }
        return "[#if group.userCount()>settings.minUserCount]\n[/#if]\n[#foreach v in [1,'2']]\n  ${v}[/#foreach]\n[#-- comment --]";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        ArrayList descriptors = ContainerUtil.newArrayList();
        for (Field field : FtlSyntaxHighlighter.class.getFields()) {
            if (!field.getName().startsWith("FTL_")) continue;
            try {
                String name = StringUtil.capitalize((String)field.getName().substring("FTL_".length()).replace('_', ' ').toLowerCase());
                descriptors.add(new AttributesDescriptor(name, (TextAttributesKey)field.get(null)));
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        AttributesDescriptor[] attributesDescriptorArray = descriptors.toArray(new AttributesDescriptor[descriptors.size()]);
        if (attributesDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlColorSettingsPage", "getAttributeDescriptors"));
        }
        return attributesDescriptorArray;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        if ("FreeMarker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlColorSettingsPage", "getDisplayName"));
        }
        return "FreeMarker";
    }
}

