/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URIUtil {
    private static final Pattern DRIVE_LETTER_PATTERN = Pattern.compile("(.):\\\\(.*)");

    public static URI resolve(URI baseURI, String reference) throws URISyntaxException {
        URI resolved;
        boolean emptyRef = reference.isEmpty();
        if (emptyRef) {
            resolved = baseURI.resolve(URI.create("#"));
            String resolvedStr = resolved.toASCIIString();
            resolved = URI.create(resolvedStr.substring(0, resolvedStr.indexOf(35)));
        } else {
            Matcher driveLetterMatcher = DRIVE_LETTER_PATTERN.matcher(reference);
            if (driveLetterMatcher.matches()) {
                String path = "///" + reference.replace('\\', '/');
                resolved = new URI("file", null, path, null);
            } else {
                resolved = baseURI.resolve(reference.replace('\\', '/'));
            }
        }
        return resolved;
    }
}

