/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.AddSourceContentsActionKt;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction;", "Lcom/jetbrains/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "()V", "perform", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "JavaScriptDebugger"})
public final class AddSourceContentsAction
extends BaseSourceMapAction {
    @Override
    protected void perform(@NotNull SourceMap sourceMap, @NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(file, project, sourceMap, project, "Add sources content to " + SourceMapInspectorKt.getFileTitle(file), true){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceMap $sourceMap;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                String string;
                File file;
                CharSequence charSequence;
                Object object;
                void size$iv;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                InputStreamReader reader = new InputStreamReader(this.$file.getInputStream(), CharsetToolkit.UTF8_CHARSET);
                Map map = (Map)gson.fromJson((Reader)reader, (Type)((Object)Map.class));
                reader.close();
                if (map.containsKey(AddSourceContentsActionKt.access$getSOURCES_CONTENT$p())) {
                    ((NotificationGroup)AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p().getValue()).createNotification("Source Map has already sources content", MessageType.INFO).notify(this.$project);
                    return;
                }
                V v = map.get("sources");
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                List sources = (List)v;
                int n = sources.size();
                String[] result$iv = new String[size$iv];
                boolean bl = false;
                void var10_12 = size$iv - true;
                if (bl <= var10_12) {
                    void i$iv;
                    do {
                        void it;
                        void var11_14 = ++i$iv;
                        void var15_18 = i$iv;
                        object = result$iv;
                        VirtualFile virtualFile = SourceMapInspectorKt.getSourceFile(this.$sourceMap.getSources()[it]);
                        if (virtualFile == null) {
                            Intrinsics.throwNpe();
                        }
                        object[var15_18] = charSequence = VfsUtilCore.loadText((VirtualFile)virtualFile);
                    } while (i$iv != var10_12);
                }
                String[] sourcesContent = (String[])((Object[])result$iv);
                String string2 = AddSourceContentsActionKt.access$getSOURCES_CONTENT$p();
                List<String> list = Arrays.asList(Arrays.copyOf(sourcesContent, sourcesContent.length));
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<String>(*sourcesContent)");
                map.put(string2, list);
                String path = this.$file.getPath();
                int index = StringsKt.lastIndexOf$default((CharSequence)path, (String)".map", (int)0, (boolean)false, (int)6, null);
                String ext = ".source.map";
                File file2 = file;
                Object object2 = file;
                CharSequence charSequence2 = new StringBuilder();
                if (index > -1) {
                    String it = path;
                    int n2 = 0;
                    charSequence = charSequence2;
                    File file3 = file2;
                    object = object2;
                    String string3 = it;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2, index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string5 = string4;
                    object2 = object;
                    file2 = file3;
                    charSequence2 = charSequence;
                    string = string5;
                } else {
                    String string6 = path;
                    string = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"path");
                }
                file2(charSequence2.append(string).append(ext).toString());
                File outFile = object2;
                OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), CharsetToolkit.UTF8_CHARSET);
                try {
                    gson.toJson((Object)map, (Appendable)stream);
                }
                finally {
                    stream.close();
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outFile);
                ((NotificationGroup)AddSourceContentsActionKt.access$getNOTIFICATION_GROUP$p().getValue()).createNotification("Source Map with sources content created: " + outFile.getName(), MessageType.INFO).notify(this.$project);
            }
            {
                this.$file = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$sourceMap = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }
}

