/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import java.awt.Color;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;

final class SourceMapVisualizer {
    private static final TextAttributes UNMAPPED_MARKER = SourceMapVisualizer.createTextAttributes((Color)JBColor.LIGHT_GRAY);
    public static final TextAttributes SELECTED_MARKER = new TextAttributes((Color)JBColor.WHITE, (Color)JBColor.BLACK, (Color)JBColor.BLACK, EffectType.ROUNDED_BOX, 0);
    private static final TextAttributes[] MAPPED_MARKERS = new TextAttributes[]{SourceMapVisualizer.createTextAttributes(new Color(16770648)), SourceMapVisualizer.createTextAttributes(new Color(0xFFCC66)), SourceMapVisualizer.createTextAttributes(new Color(0xFFBBBB)), SourceMapVisualizer.createTextAttributes(new Color(0xAAFFFF)), SourceMapVisualizer.createTextAttributes(new Color(0xFFAAFF))};

    SourceMapVisualizer() {
    }

    private static TextAttributes createTextAttributes(Color color) {
        return new TextAttributes(null, color, (Color)JBColor.WHITE, EffectType.BOXED, 0);
    }

    private static TextAttributes getTextAttributes(int line) {
        if (line == -1) {
            return UNMAPPED_MARKER;
        }
        return MAPPED_MARKERS[line % MAPPED_MARKERS.length];
    }

    public static void addMarkersToGeneratedFile(@NotNull SourceMap map, @NotNull MarkupModel markupModel) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapVisualizer", "addMarkersToGeneratedFile"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapVisualizer", "addMarkersToGeneratedFile"));
        }
        SourceMapVisualizer.addHighlighters(map.getMappings(), markupModel);
    }

    public static void addMarkersToSourceFile(SourceMap map, MarkupModel markupModel, Url sourceUrl) {
        MappingList mappings = map.getSourceResolver().findMappings(Collections.singletonList(sourceUrl), map, null);
        assert (mappings != null);
        SourceMapVisualizer.addHighlighters(mappings, markupModel);
    }

    public static void addHighlighters(@NotNull MappingList mappings, @NotNull MarkupModel markupModel) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapVisualizer", "addHighlighters"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/jetbrains/javascript/debugger/sourcemap/visualizer/SourceMapVisualizer", "addHighlighters"));
        }
        Document document = markupModel.getDocument();
        int currentLine = -1;
        int currentColumn = 0;
        for (int i = 0; i < mappings.getSize(); ++i) {
            int endOffset;
            MappingEntry mapping = mappings.get(i);
            if (mappings.getLine(mapping) - currentLine > 1) {
                markupModel.addRangeHighlighter(document.getLineStartOffset(currentLine + 1), document.getLineEndOffset(mappings.getLine(mapping) - 1), 6000, UNMAPPED_MARKER, HighlighterTargetArea.EXACT_RANGE);
            }
            currentLine = mappings.getLine(mapping);
            assert (currentLine > -1);
            int lineStartOffset = document.getLineStartOffset(currentLine);
            int startOffset = lineStartOffset + currentColumn;
            MappingEntry nextMapping = mappings.getNextOnTheSameLine(i);
            if (nextMapping == null) {
                endOffset = document.getLineEndOffset(currentLine);
                currentColumn = 0;
            } else {
                currentColumn = mappings.getColumn(nextMapping);
                endOffset = lineStartOffset + currentColumn;
            }
            if (startOffset >= endOffset) continue;
            markupModel.addRangeHighlighter(startOffset, endOffset, 6000, SourceMapVisualizer.getTextAttributes(mapping.getSourceLine()), HighlighterTargetArea.EXACT_RANGE);
        }
    }
}

