/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import com.jetbrains.javascript.debugger.V8ValueMarkerProvider;
import com.jetbrains.javascript.debugger.V8ValueMarkerProviderKt;
import com.jetbrains.javascript.debugger.ValueMarkersRefIds;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016H&J\u0015\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/javascript/debugger/V8ValueMarkerProvider;", "Lcom/intellij/xdebugger/frame/XValueMarkerProvider;", "Lorg/jetbrains/debugger/VariableView;", "", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "markedObjectExpression", "", "markers", "Lgnu/trove/TIntHashSet;", "nextMarker", "canMark", "", "value", "computeRefIds", "Lcom/jetbrains/javascript/debugger/ValueMarkersRefIds;", "computeRefIds$JavaScriptDebugger", "getMarker", "(Lorg/jetbrains/debugger/VariableView;)Ljava/lang/Integer;", "getMarkersRefIds", "getRefId", "Lorg/jetbrains/debugger/values/Value;", "markValue", "storeMarkedValue", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "marker", "unmarkValue", "JavaScriptDebugger"})
public abstract class V8ValueMarkerProvider
extends XValueMarkerProvider<VariableView, Integer> {
    private final TIntHashSet markers;
    private int nextMarker;
    private final String markedObjectExpression;
    private final JavaScriptDebugProcess<?> debugProcess;

    public boolean canMark(@NotNull VariableView value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.getRefId(value.getValue()) != null && value.getEvaluationExpression() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Integer markValue(@NotNull VariableView value) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        TIntHashSet tIntHashSet = this.markers;
        synchronized (tIntHashSet) {
            int n2 = this.nextMarker;
            this.nextMarker = n2 + 1;
            int marker = n2;
            this.markers.add(marker);
            n = marker;
        }
        int marker = n;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        if (valueMarkersRefIds == null) {
            Intrinsics.throwNpe();
        }
        String string = this.getRefId(value.getValue());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        valueMarkersRefIds.addMarker(marker, string);
        EvaluateContext evaluateContext = value.getEvaluateContext();
        String string2 = value.getEvaluationExpression();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        this.storeMarkedValue(evaluateContext, marker, string2);
        return marker;
    }

    @Nullable
    public Integer getMarker(@NotNull VariableView value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = this.getRefId(value.getValue());
        if (string == null) {
            return null;
        }
        String refId = string;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        if (valueMarkersRefIds == null) {
            Intrinsics.throwNpe();
        }
        return valueMarkersRefIds.getMarker(refId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkValue(@NotNull VariableView value, int marker) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        if (valueMarkersRefIds != null) {
            valueMarkersRefIds.removeMarker(marker);
        }
        TIntHashSet tIntHashSet = this.markers;
        synchronized (tIntHashSet) {
            boolean bl = this.markers.remove(marker);
        }
        this.storeMarkedValue(value.getEvaluateContext(), marker, "null");
    }

    private final ValueMarkersRefIds getMarkersRefIds() {
        XSuspendContext xSuspendContext = this.debugProcess.getSession().getSuspendContext();
        if (xSuspendContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.javascript.debugger.JavaScriptSuspendContext");
        }
        return ((JavaScriptSuspendContext)xSuspendContext).getMarkersRefIds$JavaScriptDebugger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ValueMarkersRefIds computeRefIds$JavaScriptDebugger() {
        void ids;
        int[] nArray;
        ValueMarkersRefIds refIds = new ValueMarkersRefIds();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Object object = this.markers;
        Ref.ObjectRef objectRef2 = objectRef;
        synchronized (object) {
            nArray = this.markers.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : this.markers.toArray();
        }
        int[] nArray2 = nArray;
        objectRef2.element = nArray2;
        object = (int[])ids.element;
        Object object2 = object;
        if (!(((TIntHashSet)object2).length == 0)) {
            Vm vm = this.debugProcess.getMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            EvaluateContext evaluateContext = vm.getEvaluateContext();
            if (evaluateContext == null) {
                Intrinsics.throwNpe();
            }
            EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)this.markedObjectExpression, null, (boolean)false, (int)6, null).done((Consumer)new Consumer<EvaluateResult>(this, (Ref.ObjectRef)ids, refIds){
                final /* synthetic */ V8ValueMarkerProvider this$0;
                final /* synthetic */ Ref.ObjectRef $ids;
                final /* synthetic */ ValueMarkersRefIds $refIds;

                public final void consume(EvaluateResult it) {
                    block1: {
                        Value value = it.getValue();
                        if (!(value instanceof ObjectValue)) {
                            value = null;
                        }
                        ObjectValue objectValue = (ObjectValue)value;
                        if (objectValue == null) break block1;
                        ObjectValue objectValue2 = objectValue;
                        ObjectValue it2 = objectValue2;
                        it2.getProperties().done((Consumer)new Consumer<List<? extends Variable>>(this){
                            final /* synthetic */ computeRefIds.1 this$0;

                            public final void consume(List<? extends Variable> it) {
                                Arrays.sort((int[])this.this$0.$ids.element);
                                for (Variable variable : it) {
                                    int id = StringUtil.parseInt((String)variable.getName(), (int)-1);
                                    if (id == -1 || Arrays.binarySearch((int[])this.this$0.$ids.element, id) == -1) continue;
                                    ValueMarkersRefIds valueMarkersRefIds = this.this$0.$refIds;
                                    String string = this.this$0.this$0.getRefId(variable.getValue());
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    valueMarkersRefIds.addMarker(id, string);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                {
                    this.this$0 = v8ValueMarkerProvider;
                    this.$ids = objectRef;
                    this.$refIds = valueMarkersRefIds;
                }
            });
        }
        return refIds;
    }

    private final void storeMarkedValue(EvaluateContext evaluateContext, int marker, String value) {
        String expression = StringsKt.trimIndent((String)("\n" + "    (function() {" + "\n" + "      var m = " + this.markedObjectExpression + ";" + "\n" + "      if (m == null) {" + "\n" + "        if (typeof WeakMap == " + "\"" + "undefined" + "\"" + ") {" + "\n" + "          return;" + "\n" + "        }" + "\n" + "        m = new WeakMap();" + "\n" + "        " + this.markedObjectExpression + " = m;" + "\n" + "      }" + "\n" + "      m.set(" + value + ", " + marker + ");" + "\n" + "    })()" + "\n" + "      "));
        EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, (int)6, null).rejected((Consumer)storeMarkedValue.1.INSTANCE);
    }

    @Nullable
    public abstract String getRefId(@Nullable Value var1);

    public V8ValueMarkerProvider(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(VariableView.class);
        this.debugProcess = debugProcess;
        this.markers = new TIntHashSet();
        this.markedObjectExpression = (this.debugProcess.isFilesOnlyInLocalFileSystem() ? "global" : "window") + "." + V8ValueMarkerProviderKt.MARKED_OBJECTS_PROPERTY;
    }
}

