/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.breakpoints.JavaScriptTemplateLanguageHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;

public class JsFileUtil {
    public static final int MAX_TITLE_LENGTH = 150;

    private JsFileUtil() {
    }

    @NotNull
    public static String getShortenedFilePath(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JsFileUtil", "getShortenedFilePath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/JsFileUtil", "getShortenedFilePath"));
        }
        if (!file.isInLocalFileSystem()) {
            String string = file.getUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JsFileUtil", "getShortenedFilePath"));
            }
            return string;
        }
        String name = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)project.getBaseDir(), (char)File.separatorChar);
        String string = name == null ? FileUtil.getLocationRelativeToUserHome((String)file.getPath()) : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JsFileUtil", "getShortenedFilePath"));
        }
        return string;
    }

    @NotNull
    public static String trimTitle(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/JsFileUtil", "trimTitle"));
        }
        String string = StringUtil.trimMiddle((String)url, (int)150);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/JsFileUtil", "trimTitle"));
        }
        return string;
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createNavigatable(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/JsFileUtil", "createNavigatable"));
        }
        return file == null ? null : new OpenFileDescriptor(project, file);
    }

    public static boolean isOnBuiltInWebServer(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/JsFileUtil", "isOnBuiltInWebServer"));
        }
        return BuiltInServerManager.getInstance().isOnBuiltInWebServer(url);
    }

    public static boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authority", "com/jetbrains/javascript/debugger/JsFileUtil", "isOnBuiltInWebServerByAuthority"));
        }
        return BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)authority);
    }

    public static boolean isScript(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/javascript/debugger/JsFileUtil", "isScript"));
        }
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || fileType.getName().equals("Dart") && fileType.getDefaultExtension().equals("dart");
    }

    public static boolean isHtmlOrJavaScript(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JsFileUtil", "isHtmlOrJavaScript"));
        }
        FileType fileType = file.getFileType();
        return HtmlUtil.isHtmlFile((VirtualFile)file) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
    }

    public static boolean isHtmlOrTemplateFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/JsFileUtil", "isHtmlOrTemplateFile"));
        }
        return HtmlUtil.isHtmlFile((VirtualFile)file) || JsFileUtil.isTemplateFileType(file.getFileType());
    }

    public static boolean isTemplateFileType(FileType fileType) {
        for (JavaScriptTemplateLanguageHandler handler : (JavaScriptTemplateLanguageHandler[])JavaScriptTemplateLanguageHandler.EP_NAME.getExtensions()) {
            if (!handler.isTemplateFileType(fileType)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDebuggableElement(int line, @NotNull Project project, @NotNull Document document, boolean inEventHandler, boolean requireJsElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/JsFileUtil", "containsDebuggableElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/JsFileUtil", "containsDebuggableElement"));
        }
        Ref result = Ref.create((Object)false);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, element -> {
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            if (requireJsElement) {
                JSElement jsElement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSElement.class, (boolean)false);
                if (jsElement != null && (!inEventHandler || JsFileUtil.isInEventHandler(jsElement))) {
                    result.set((Object)true);
                    return false;
                }
            } else {
                result.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.get();
    }

    private static boolean isInEventHandler(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/JsFileUtil", "isInEventHandler"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null;
    }

    public static boolean isWebKitRuntime(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/javascript/debugger/JsFileUtil", "isWebKitRuntime"));
        }
        if (browser.getFamily() != BrowserFamily.CHROME) {
            return false;
        }
        String browserPath = browser.getPath();
        return browserPath != null && (browserPath.equals("node-webkit") || browserPath.endsWith("/node-webkit") || browserPath.equals("nw") || browserPath.endsWith("/nw") || browserPath.equals("nwjs") || browserPath.endsWith("/nwjs") || browserPath.endsWith("/nw.exe"));
    }
}

