/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.javascript.debugger.FunctionStepIntoVariant;
import com.jetbrains.javascript.debugger.VariantsCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.PsiVisitors;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptSmartStepIntoHandler;", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "Lcom/jetbrains/javascript/debugger/FunctionStepIntoVariant;", "mySession", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/xdebugger/XDebugSession;)V", "getMySession", "()Lcom/intellij/xdebugger/XDebugSession;", "computeSmartStepVariants", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "getPopupTitle", "", "kotlin.jvm.PlatformType", "JavaScriptDebugger"})
public abstract class JavaScriptSmartStepIntoHandler
extends XSmartStepIntoHandler<FunctionStepIntoVariant> {
    @NotNull
    private final XDebugSession mySession;

    public String getPopupTitle(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return JSDebuggerBundle.message("popup.title.step.into.function", new Object[0]);
    }

    @NotNull
    public List<FunctionStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        VariantsCollector visitor = new VariantsCollector();
        PsiVisitors.visit((XSourcePosition)position, (Project)this.mySession.getProject(), (PsiVisitors.Visitor)visitor);
        List list = ContainerUtil.notNullize(visitor.getVariants());
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.notNullize(visitor.variants)");
        return list;
    }

    @NotNull
    protected final XDebugSession getMySession() {
        return this.mySession;
    }

    public JavaScriptSmartStepIntoHandler(@NotNull XDebugSession mySession) {
        Intrinsics.checkParameterIsNotNull((Object)mySession, (String)"mySession");
        this.mySession = mySession;
    }
}

