/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.javascript.debugger.NameMapperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"doExtractName", "", "rawGeneratedName", "", "JavaScriptDebugger"})
public final class JavaScriptNameMapperKt {
    @NotNull
    public static final String doExtractName(@NotNull CharSequence rawGeneratedName) {
        Intrinsics.checkParameterIsNotNull((Object)rawGeneratedName, (String)"rawGeneratedName");
        String generatedName = NameMapperKt.getNAME_TRIMMER().trimFrom(rawGeneratedName);
        int i = StringsKt.indexOf$default((CharSequence)generatedName, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (i > 0) {
            JSFlexAdapter lexer = new JSFlexAdapter(DialectOptionHolder.ECMA_6);
            lexer.start((CharSequence)generatedName);
            while (lexer.getTokenType() != null) {
                IElementType tokenType;
                if (Intrinsics.areEqual((Object)tokenType, (Object)JSTokenTypes.IDENTIFIER)) {
                    String string = lexer.getTokenText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lexer.tokenText");
                    return string;
                }
                lexer.advance();
            }
        }
        String string = generatedName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generatedName");
        return string;
    }
}

