/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.plugins.webDeployment.actions.PublishedFileBrowserUrlProvider;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

class DeploymentServerFileUrlMapper
extends FileUrlMapper {
    DeploymentServerFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/DeploymentServerFileUrlMapper", "getUrls"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DeploymentServerFileUrlMapper", "getUrls"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)PublishedFileBrowserUrlProvider.getUrl((Project)project, (VirtualFile)file));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/DeploymentServerFileUrlMapper", "getUrls"));
        }
        return list;
    }

    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        VirtualFile result;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/javascript/debugger/DeploymentServerFileUrlMapper", "getFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/DeploymentServerFileUrlMapper", "getFile"));
        }
        if (url.isInLocalFileSystem()) {
            return null;
        }
        List servers = WebServersConfigManager.getInstance((Project)project).getServers(false);
        String authority = url.getAuthority();
        if (StringUtil.isEmpty((String)authority) || servers.isEmpty()) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        WebServerConfig defaultServer = publishConfig.findDefaultServer();
        VirtualFile virtualFile = result = defaultServer == null || defaultServer.validateUrl() != null ? null : DeploymentServerFileUrlMapper.urlToFile(url, defaultServer, authority, publishConfig);
        if (result == null) {
            TreeMap<String, WebServerConfig> sortedServers = new TreeMap<String, WebServerConfig>((o1, o2) -> o2.compareTo((String)o1));
            for (WebServerConfig server : servers) {
                if (server == defaultServer || server.validateUrl() != null) continue;
                sortedServers.put(server.getUrl(), server);
            }
            for (WebServerConfig server : sortedServers.values()) {
                result = DeploymentServerFileUrlMapper.urlToFile(url, server, authority, publishConfig);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Nullable
    private static VirtualFile urlToFile(Url url, WebServerConfig server, String authority, PublishConfig publishConfig) {
        DeploymentPathMapping mapping;
        URL javaUrl;
        try {
            javaUrl = new URL(server.getUrl());
            if (!authority.equalsIgnoreCase(javaUrl.getAuthority())) {
                return null;
            }
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        String path = url.getPath();
        if (!StringUtil.isEmpty((String)javaUrl.getPath())) {
            if (!path.startsWith(javaUrl.getPath())) {
                return null;
            }
            path = path.substring(javaUrl.getPath().length());
        }
        if ((mapping = publishConfig.getNearestMappingForWeb(path, false, true, false, (Mappable)server)) != null) {
            VirtualFile parent = LocalFileFinder.findFile((String)mapping.getLocalPath());
            String pathRemainderForWeb = parent == null ? null : mapping.getPathRemainderForWeb(path);
            return pathRemainderForWeb == null ? null : parent.findFileByRelativePath(pathRemainderForWeb);
        }
        return null;
    }
}

