/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.Annotation;
import com.jetbrains.javascript.debugger.ConsoleMessage;
import com.jetbrains.javascript.debugger.ConsolePrinterKt;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JsFileUtil;
import com.jetbrains.javascript.debugger.LineAnnotationMap;
import com.jetbrains.javascript.debugger.SegmentList;
import java.awt.Color;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Vm;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 K2\u00020\u0001:\u0001KB\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000fJ0\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u0005J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001c2\b\b\u0002\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001cJ\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016JD\u0010+\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\b\u0010/\u001a\u0004\u0018\u00010\u001cH\u0002J \u00100\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(H\u0016J(\u00104\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u0013\u00109\u001a\u00070\u001c\u00a2\u0006\u0002\b:2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010;\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\u0005H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J\u0006\u0010?\u001a\u00020\u0016J\u0006\u0010@\u001a\u00020\u0016J\b\u0010A\u001a\u00020\u0005H\u0016J\u0006\u0010B\u001a\u00020\u0016J\u0006\u0010C\u001a\u00020\u0016J\u0006\u0010D\u001a\u00020\u0016J\u000e\u0010E\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ2\u0010F\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010G\u001a\u00020\u0016J\u0010\u0010H\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u0018\u0010I\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020JH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/jetbrains/javascript/debugger/ConsolePrinter;", "Lcom/intellij/execution/console/BasicGutterContentProvider;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "isLineRelationshipComputable", "", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;Z)V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "hasNewLines", "indentLevel", "", "lastMessageStartOffset", "lineToAnnotation", "Lcom/jetbrains/javascript/debugger/LineAnnotationMap;", "relatedLines", "Lcom/jetbrains/javascript/debugger/SegmentList;", "add", "", "message", "Lcom/jetbrains/javascript/debugger/ConsoleMessage;", "repeatCount", "addFileLink", "url", "", "line", "column", "functionName", "resolveToScript", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "appendError", "beforeUiComponentUpdate", "editor", "Lcom/intellij/openapi/editor/Editor;", "clear", "doAction", "doAddFileLink", "suggestedLine", "suggestedColumn", "print", "scriptId", "doIsShowSeparatorLine", "document", "Lcom/intellij/openapi/editor/Document;", "documentCleared", "drawIcon", "g", "Ljava/awt/Graphics;", "y", "getLineStartGutterOverlap", "getLinkText", "Lorg/jetbrains/annotations/NotNull;", "getStringInfo", "toolTip", "getText", "getToolTip", "groupEnd", "groupStart", "hasText", "indentIn", "indentOut", "newLine", "printBrowserLink", "printFileLink", "printIndent", "printSystem", "setRepeatCount", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Companion", "JavaScriptDebugger"})
public final class ConsolePrinter
extends BasicGutterContentProvider {
    private volatile int lastMessageStartOffset;
    private int indentLevel;
    private final LineAnnotationMap lineToAnnotation;
    private final SegmentList relatedLines;
    private boolean hasNewLines;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private static final Key<Object> CONSOLE_INFO_KEY;
    public static final Companion Companion;

    private final ConsoleView getConsoleView() {
        return this.debugProcess.getSession().getConsoleView();
    }

    public void beforeUiComponentUpdate(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.lineToAnnotation.commit(editor.getDocument());
    }

    public void documentCleared(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.lineToAnnotation.clear();
        this.relatedLines.clear();
        this.debugProcess.consoleCleared();
        this.lastMessageStartOffset = -1;
        this.hasNewLines = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull ConsoleMessage message, int repeatCount) {
        block13: {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            ConsoleView consoleView = this.getConsoleView();
            if (consoleView == null) break block13;
            ConsoleView consoleView2 = consoleView;
            ConsoleView consoleView3 = consoleView2;
            int startOffset = consoleView3.getContentSize();
            if (this.indentLevel != 0) {
                this.printIndent();
            }
            this.hasNewLines = false;
            try {
                message.print(consoleView3, this);
            }
            finally {
                boolean markAsRelatedLines = this.hasNewLines;
                this.lastMessageStartOffset = startOffset;
                this.hasNewLines = false;
                if (markAsRelatedLines) {
                    int endOffset = consoleView3.getContentSize();
                    SegmentList segmentList = this.relatedLines;
                    synchronized (segmentList) {
                        this.relatedLines.add(startOffset, endOffset);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
            if (consoleView3 instanceof ConsoleViewImpl) {
                this.setRepeatCount(repeatCount, (ConsoleViewImpl)consoleView3);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void add$default(ConsolePrinter consolePrinter, ConsoleMessage consoleMessage, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        consolePrinter.add(consoleMessage, n);
    }

    private final void setRepeatCount(int repeatCount, ConsoleViewImpl consoleView) {
        if (repeatCount <= 0) {
            return;
        }
        int offset = this.lastMessageStartOffset;
        if (offset < 0) {
            return;
        }
        Annotation annotation = (Annotation)this.lineToAnnotation.getByOffset(offset);
        if (annotation == null) {
            annotation = (Annotation)this.lineToAnnotation.get(consoleView.getEditor().getDocument().getLineNumber(offset));
        }
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        annotation2.setRepeatCount(repeatCount);
        if (repeatCount < 10) {
            return;
        }
        int excess = Integer.toString(repeatCount).length() + 1 - ConsolePrinter.access$getMAX_LINE_END_GUTTER_WIDTH_IN_CHAR$p$s-19397937();
        boolean bl = excess > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this, offset, excess){
            final /* synthetic */ ConsolePrinter this$0;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $excess;

            public final void run() {
                block1: {
                    ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)this.this$0.getDebugProcess().getSession().getConsoleView();
                    if (consoleViewImpl == null) break block1;
                    ConsoleViewImpl consoleViewImpl2 = consoleViewImpl;
                    ConsoleViewImpl consoleView = consoleViewImpl2;
                    consoleView.flushDeferredText();
                    Document document = consoleView.getEditor().getDocument();
                    int startOffset = document.getLineStartOffset(document.getLineNumber(this.$offset));
                    int missed = this.$excess - StringUtil.countChars((CharSequence)document.getImmutableCharSequence(), (char)' ', (int)startOffset, (boolean)true);
                    if (missed > 0) {
                        document.insertString(startOffset, (CharSequence)StringUtil.repeat((String)" ", (int)missed));
                    }
                }
            }
            {
                this.this$0 = consolePrinter;
                this.$offset = n;
                this.$excess = n2;
            }
        });
    }

    public final void indentIn() {
        int n = this.indentLevel;
        this.indentLevel = n + 1;
    }

    public final void indentOut() {
        int n = this.indentLevel;
        this.indentLevel = n + -1;
    }

    public final void newLine() {
        this.printSystem("\n");
    }

    public final void printIndent() {
        int l = this.indentLevel;
        while (l-- > 0) {
            ConsoleView consoleView = this.getConsoleView();
            if (consoleView == null) {
                Intrinsics.throwNpe();
            }
            consoleView.print(ConsolePrinterKt.access$getINDENT$p(), ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    public final void groupStart() {
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        ConsoleView consoleView = this.getConsoleView();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.print(">", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public final void groupEnd() {
        int n = this.indentLevel;
        this.indentLevel = n + -1;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
        ConsoleView consoleView = this.getConsoleView();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.print("<", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    private final void printSystem(String text) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        this.append(text, consoleViewContentType);
    }

    public final void appendError(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        this.append(text, consoleViewContentType);
    }

    public final void append(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (text.length() > 1 && StringsKt.contains$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null)) {
            this.hasNewLines = true;
        }
        ConsoleView consoleView = this.getConsoleView();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.print(text, contentType);
    }

    public static /* bridge */ /* synthetic */ void append$default(ConsolePrinter consolePrinter, String string, ConsoleViewContentType consoleViewContentType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
        }
        if ((n & 2) != 0) {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
            consoleViewContentType = consoleViewContentType2;
        }
        consolePrinter.append(string, consoleViewContentType);
    }

    public final void printFileLink(@Nullable String scriptId, @NotNull String url, int line, int column, @Nullable String functionName) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.doAddFileLink(url, line, column, functionName, false, true, scriptId);
    }

    public final void addFileLink(@NotNull String url, int line, int column, @Nullable String functionName, boolean resolveToScript) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.doAddFileLink(url, line, column, functionName, false, resolveToScript, null);
    }

    private final void doAddFileLink(String url, int suggestedLine, int suggestedColumn, String functionName, boolean print, boolean resolveToScript, String scriptId) {
        VirtualFile file;
        Url parsedUrl;
        SourceInfo sourceInfo;
        SourceInfo sourceInfo2;
        int line = suggestedLine;
        int column = suggestedColumn;
        if (resolveToScript) {
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            sourceInfo2 = this.debugProcess.getSourceInfo(vm, scriptId, url, functionName, line, column);
        } else {
            sourceInfo2 = sourceInfo = (SourceInfo)null;
        }
        if (sourceInfo == null) {
            parsedUrl = Urls.parse((String)url, (boolean)true);
            VirtualFile virtualFile = file = parsedUrl == null ? (VirtualFile)null : JavaScriptDebugProcess.findFile$default(this.debugProcess, parsedUrl, false, 2, null);
            if (file == null && print) {
                this.printBrowserLink(url);
                return;
            }
        } else {
            file = sourceInfo.getFile();
            line = sourceInfo.getLine();
            column = sourceInfo.getColumn();
            parsedUrl = null;
        }
        Project project = this.debugProcess.getSession().getProject();
        if (print) {
            ConsoleView consoleView = this.getConsoleView();
            if (consoleView == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder = new StringBuilder();
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            consoleView.printHyperlink(stringBuilder.append(virtualFile.getName()).append(line < 0 ? "" : ":" + (line + 1)).toString(), (HyperlinkInfo)new OpenFileHyperlinkInfo(project, file, line, column));
        } else {
            Annotation annotation;
            boolean addToFileMap = true;
            if (file == null) {
                Url url2 = parsedUrl;
                if (url2 == null) {
                    url2 = (Url)new UrlImpl(url);
                }
                annotation = new Annotation(url2, line, column);
            } else if (line < 0) {
                annotation = new Annotation(file, line, column, null);
            } else {
                annotation = this.lineToAnnotation.find(file, line, column);
                if (annotation == null) {
                    annotation = new Annotation(file, line, column, LazyRangeMarkerFactory.getInstance((Project)project).createRangeMarker(file, line, column, false));
                } else {
                    addToFileMap = false;
                }
            }
            ConsoleView consoleView = this.getConsoleView();
            if (consoleView == null) {
                Intrinsics.throwNpe();
            }
            this.lineToAnnotation.add(Math.max(consoleView.getContentSize() - 1, 0), annotation, addToFileMap);
        }
    }

    public final void printBrowserLink(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ConsoleView consoleView = this.getConsoleView();
        if (consoleView == null) {
            Intrinsics.throwNpe();
        }
        consoleView.printHyperlink(this.getLinkText(url), (HyperlinkInfo)new OpenUrlHyperlinkInfo(url, this.debugProcess.getConnection().getBrowser()));
    }

    public final void clear() {
        block0: {
            ConsoleView consoleView = this.debugProcess.getSession().getConsoleView();
            if (consoleView == null) break block0;
            consoleView.clear();
        }
    }

    @NotNull
    public final String getLinkText(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return JsFileUtil.trimTitle(url);
    }

    public boolean hasText() {
        return !this.lineToAnnotation.isEmpty();
    }

    @Nullable
    public String getText(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.getStringInfo(line, false);
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.getStringInfo(line, true);
    }

    private final String getStringInfo(int line, boolean toolTip) {
        String name;
        Annotation annotation = (Annotation)this.lineToAnnotation.get(line);
        if (annotation == null) {
            return null;
        }
        Annotation annotation2 = annotation;
        VirtualFile file = annotation2.getFile();
        if (toolTip) {
            if (annotation2.getUrl() != null) {
                String string = annotation2.getUrl().trimParameters().toDecodedForm();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                name = string;
            } else {
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                String string = JsFileUtil.getShortenedFilePath(virtualFile, this.debugProcess.getSession().getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsFileUtil.getShortenedF\u2026gProcess.session.project)");
                name = string;
            }
        } else {
            if (annotation2.getUrl() == null) {
                boolean bl = file != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                String string = virtualFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file!!.name");
                name = string;
            } else {
                String string = annotation2.getUrl().trimParameters().toDecodedForm();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                name = string;
            }
            String string = StringUtil.trimMiddle((String)name, (int)100);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.trimMiddle(name, 100)");
            name = string;
        }
        return annotation2.getLine() < 0 ? name : name + ":" + (annotation2.getLine() + 1);
    }

    public void doAction(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Annotation annotation = (Annotation)this.lineToAnnotation.get(line);
        if (annotation != null) {
            OpenFileDescriptor descriptor;
            VirtualFile file = annotation.getFile();
            if (file == null) {
                Url url = annotation.getUrl();
                if (url == null) {
                    Intrinsics.throwNpe();
                }
                if ((file = this.debugProcess.findFileOrAny(url)) == null) {
                    this.debugProcess.getSession().reportError("Cannot navigate");
                    return;
                }
                annotation.setFile(file);
            }
            if (annotation.getPosition() == null || annotation.getLine() < 0) {
                descriptor = new OpenFileDescriptor(this.debugProcess.getSession().getProject(), file, annotation.getLine(), annotation.getColumn());
                annotation.setPosition(descriptor.getRangeMarker());
            } else {
                Project project = this.debugProcess.getSession().getProject();
                RangeMarker rangeMarker = annotation.getPosition();
                if (rangeMarker == null) {
                    Intrinsics.throwNpe();
                }
                descriptor = new OpenFileDescriptor(project, file, rangeMarker.getStartOffset());
            }
            descriptor.navigate(true);
        }
    }

    public boolean drawIcon(int line, @NotNull Graphics g, int y, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (super.drawIcon(line, g, y, editor)) {
            return true;
        }
        Annotation annotation = (Annotation)this.lineToAnnotation.get(line);
        if (annotation == null || annotation.getRepeatCount() <= 0) {
            return false;
        }
        String text = String.valueOf(annotation.getRepeatCount() + 1);
        g.setColor((Color)JBColor.LIGHT_GRAY);
        g.drawString(text, 3, y);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIsShowSeparatorLine(int line, @NotNull Editor editor, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        int lineStartOffset = document.getLineStartOffset(line);
        SegmentList segmentList = this.relatedLines;
        synchronized (segmentList) {
            block4: {
                int rangeIndex = this.relatedLines.getRangeIndex(lineStartOffset);
                if (rangeIndex == -1) break block4;
                boolean bl = !this.relatedLines.rangeContains(rangeIndex, document.getLineStartOffset(line + 1));
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.isLineRelationshipComputable;
    }

    public int getLineStartGutterOverlap(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return EditorUtil.getSpaceWidth((int)0, (Editor)editor) * 3;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public ConsolePrinter(@NotNull JavaScriptDebugProcess<?> debugProcess, boolean isLineRelationshipComputable) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(isLineRelationshipComputable);
        this.debugProcess = debugProcess;
        this.lastMessageStartOffset = -1;
        this.lineToAnnotation = new LineAnnotationMap();
        this.relatedLines = new SegmentList();
    }

    static {
        Companion = new Companion(null);
        CONSOLE_INFO_KEY = new Key("CONSOLE_INFO_KEY");
        ConsoleViewContentType.registerNewConsoleViewType(Companion.getCONSOLE_INFO_KEY(), (TextAttributesKey)ConsoleViewContentType.LOG_EXPIRED_ENTRY);
    }

    public static final /* synthetic */ int access$getMAX_LINE_END_GUTTER_WIDTH_IN_CHAR$p$s-19397937() {
        return 2;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/javascript/debugger/ConsolePrinter$Companion;", "", "()V", "CONSOLE_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "getCONSOLE_INFO_KEY", "()Lcom/intellij/openapi/util/Key;", "JavaScriptDebugger"})
    public static final class Companion {
        @NotNull
        public final Key<Object> getCONSOLE_INFO_KEY() {
            return CONSOLE_INFO_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

