/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.browserConnection;

import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.project.Project;
import com.jetbrains.browserConnection.BrowserConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.jsonRpc.Client;

final class SmartUrlOpener
extends UrlOpener {
    SmartUrlOpener() {
    }

    public boolean openUrl(@NotNull WebBrowser browser, @NotNull String url, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/SmartUrlOpener", "openUrl"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/browserConnection/SmartUrlOpener", "openUrl"));
        }
        BrowserConnectionManager browserConnectionManager = BrowserConnectionManager.getInstance();
        Client client = browserConnectionManager.findConnectedBrowser(browser);
        if (client == null) {
            return false;
        }
        browserConnectionManager.openUrl(client, url);
        return true;
    }
}

