/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.browserConnection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.browserConnection.BrowserQualifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class BrowserConnector {
    static final ExtensionPointName<BrowserConnector> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.browserConnector");

    public abstract boolean canHandle(@NotNull BrowserQualifier var1);

    @NotNull
    public abstract Promise<?> ensureExtensionInstalled(@NotNull WebBrowser var1, @Nullable Project var2);

    public String[] getLaunchParameters() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public abstract void checkVersion(@NotNull WebBrowser var1, @Nullable String var2, @Nullable Project var3);

    @Nullable
    static BrowserConnector get(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/jetbrains/browserConnection/BrowserConnector", "get"));
        }
        for (BrowserConnector connector : (BrowserConnector[])EP_NAME.getExtensions()) {
            if (!connector.canHandle(browserQualifier)) continue;
            return connector;
        }
        return null;
    }

    @Nullable
    static BrowserConnector get(@NotNull WebBrowser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/browserConnection/BrowserConnector", "get"));
        }
        switch (browser.getFamily()) {
            case CHROME: 
            case OPERA: {
                return BrowserConnector.get(BrowserQualifier.CHROME);
            }
            case FIREFOX: {
                return BrowserConnector.get(BrowserQualifier.FIREFOX);
            }
        }
        return null;
    }
}

