/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.javascript.debugger.settings.SteppingFilter;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaScriptSteppingConfigurableUi
implements ConfigurableUi<JavaScriptDebuggerSettings> {
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{new TableModelEditor.EditableColumnInfo<SteppingFilter, Boolean>(){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(SteppingFilter item) {
            return item.isEnabled();
        }

        public void setValue(SteppingFilter item, Boolean value) {
            item.setEnabled(value);
        }
    }, new TableModelEditor.EditableColumnInfo<SteppingFilter, String>(){

        public String valueOf(SteppingFilter item) {
            return item.getUrlPattern();
        }

        public void setValue(SteppingFilter item, String value) {
            item.setUrlPattern(value);
        }
    }};
    private JCheckBox doNotStepIntoLibraryCodeCheckbox;
    private JCheckBox steppingFiltersEnabledCheckbox;
    private JComponent steppingFiltersPanel;
    private JPanel panel;
    private TableModelEditor<SteppingFilter> steppingFiltersEditor;

    public JavaScriptSteppingConfigurableUi() {
        this.$$$setupUI$$$();
        this.steppingFiltersEnabledCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent e) {
                JavaScriptSteppingConfigurableUi.this.updateFiltersTable();
            }
        });
    }

    private void updateFiltersTable() {
        this.steppingFiltersEditor.enabled(this.steppingFiltersEnabledCheckbox.isSelected());
    }

    public void reset(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi", "reset"));
        }
        this.doNotStepIntoLibraryCodeCheckbox.setSelected(settings.isDoNotStepIntoLibraryCode());
        this.steppingFiltersEnabledCheckbox.setSelected(settings.isSteppingFiltersEnabled());
        this.steppingFiltersEditor.reset(settings.getSteppingFilters());
        this.updateFiltersTable();
    }

    public boolean isModified(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi", "isModified"));
        }
        return this.doNotStepIntoLibraryCodeCheckbox.isSelected() != settings.isDoNotStepIntoLibraryCode() || this.steppingFiltersEnabledCheckbox.isSelected() != settings.isSteppingFiltersEnabled() || this.steppingFiltersEditor.isModified();
    }

    public void apply(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi", "apply"));
        }
        settings.setDoNotStepIntoLibraryCode(this.doNotStepIntoLibraryCodeCheckbox.isSelected());
        settings.setSteppingFiltersEnabled(this.steppingFiltersEnabledCheckbox.isSelected());
        if (this.steppingFiltersEditor.isModified()) {
            settings.setSteppingFilters(this.steppingFiltersEditor.apply());
        }
        JavaScriptDebuggerSettings.onSettingsChanged(false, true);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        TableModelEditor.DialogItemEditor<SteppingFilter> itemEditor = new TableModelEditor.DialogItemEditor<SteppingFilter>(){

            public SteppingFilter clone(@NotNull SteppingFilter item, boolean forInPlaceEditing) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "clone"));
                }
                return new SteppingFilter(item.isEnabled(), item.getUrlPattern());
            }

            @NotNull
            public Class<SteppingFilter> getItemClass() {
                if (SteppingFilter.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "getItemClass"));
                }
                return SteppingFilter.class;
            }

            public void edit(@NotNull SteppingFilter item, @NotNull Function<SteppingFilter, SteppingFilter> mutator, boolean isAdd) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "edit"));
                }
                if (mutator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "edit"));
                }
                String pattern = Messages.showInputDialog((Component)JavaScriptSteppingConfigurableUi.this.panel, (String)JSDebuggerBundle.message("label.text.specify.url.pattern", new Object[0]), (String)JSDebuggerBundle.message("dialog.title.stepping.filter", new Object[0]), null, (String)item.getUrlPattern(), (InputValidator)new NonEmptyInputValidator());
                if (pattern != null) {
                    ((SteppingFilter)mutator.fun((Object)item)).setUrlPattern(pattern);
                }
            }

            public void applyEdited(@NotNull SteppingFilter oldItem, @NotNull SteppingFilter newItem) {
                if (oldItem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "applyEdited"));
                }
                if (newItem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/javascript/debugger/settings/JavaScriptSteppingConfigurableUi$4", "applyEdited"));
                }
                newItem.setUrlPattern(oldItem.getUrlPattern());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        this.steppingFiltersEditor = new TableModelEditor(COLUMNS, (CollectionItemEditor)itemEditor, JSDebuggerBundle.message("text.no.filters", new Object[0]));
        this.steppingFiltersPanel = this.steppingFiltersEditor.createComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.doNotStepIntoLibraryCodeCheckbox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("checkbox.text.do.not.step.into.library.scripts"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.steppingFiltersEnabledCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("checkbox.text.do.not.step.into.scripts"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComponent jComponent = this.steppingFiltersPanel;
        jPanel.add((Component)jComponent, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

