/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JsFileUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggableFileFinder {
    @Nullable
    public abstract VirtualFile findFile(@NotNull Url var1, @NotNull Project var2);

    public VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "findFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "findFile"));
        }
        return this.findFile(url, project);
    }

    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "findNavigatable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "findNavigatable"));
        }
        return JsFileUtil.createNavigatable(project, this.findFile(url, project));
    }

    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "canSetRemoteUrl"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "canSetRemoteUrl"));
        }
        return false;
    }

    @NotNull
    public abstract List<Url> getRemoteUrls(@NotNull VirtualFile var1);

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/impl/DebuggableFileFinder", "isOnlySourceMappedBreakpoints"));
        }
        JavaScriptDebugAware debugAware = JavaScriptDebugAware.getBreakpointAware((FileType)file.getFileType());
        return debugAware != null && debugAware.isOnlySourceMappedBreakpoints();
    }
}

