/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.javascript.debugger.impl.EvalScriptVirtualFile;
import com.intellij.javascript.debugger.impl.JSDebuggerEditorsProvider;
import com.intellij.javascript.debugger.impl.RemoteUrlMappingHelper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JsFileUtil;
import com.jetbrains.javascript.debugger.LambdaInLineVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

public class JavaScriptBreakpointType
extends XLineBreakpointType<JavaScriptLineBreakpointProperties> {
    private final XDebuggerEditorsProvider myEditorsProvider = new JSDebuggerEditorsProvider();

    public JavaScriptBreakpointType() {
        super("javascript", JSDebuggerBundle.message("javascript.breakpoint.title", new Object[0]));
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "getEditorsProvider"));
        }
        return this.myEditorsProvider;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document document;
        boolean canContainsJavaScript;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "canPutAt"));
        }
        if (file instanceof EvalScriptVirtualFile) {
            return false;
        }
        FileType fileType = file.getFileType();
        boolean bl = canContainsJavaScript = DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || JsFileUtil.isHtmlOrTemplateFile(file);
        if ((canContainsJavaScript || JavaScriptDebugAware.isBreakpointAware((FileType)fileType)) && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            return JsFileUtil.containsDebuggableElement(line, project, document, false, canContainsJavaScript);
        }
        return false;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        XDebugProcess debugProcess;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "getAdditionalPopupMenuActions"));
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (currentSession != null && position != null && (debugProcess = currentSession.getDebugProcess()) instanceof JavaScriptDebugProcess) {
            JavaScriptDebugProcess jsDebugProcess = (JavaScriptDebugProcess)debugProcess;
            DebuggableFileFinder fileFinder = jsDebugProcess.getFinder();
            VirtualFile file = position.getFile();
            if (fileFinder instanceof RemoteDebuggingFileFinder && !((RemoteDebuggingFileFinder)fileFinder).isDebuggable(file, currentSession.getProject()) && fileFinder.canSetRemoteUrl(file, currentSession.getProject())) {
                return Collections.singletonList(new SpecifyRemoteUrlAction(jsDebugProcess, file));
            }
        }
        return super.getAdditionalPopupMenuActions(breakpoint, currentSession);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaScriptLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaScriptLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "createBreakpointProperties"));
        }
        return new JavaScriptLineBreakpointProperties();
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    @NotNull
    public List<? extends XLineBreakpointType.XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "computeVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "computeVariants"));
        }
        SmartList result = new SmartList();
        result.add(new XLineBreakpointType.XLineBreakpointAllVariant((XLineBreakpointType)this, position));
        PsiVisitors.visit((XSourcePosition)position, (Project)project, (PsiVisitors.Visitor)new LambdaInLineVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$1", "process"));
                }
                if (firstBreakable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBreakable", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$1", "process"));
                }
                SourceInfo lambdaPosition = this.createSourcePosition(firstBreakable);
                this.val$result.add(new MyExactBreakpointVariant((XSourcePosition)lambdaPosition, (PsiElement)element, this.lambdaOrdinal++));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType", "computeVariants"));
        }
        return smartList;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaScriptLineBreakpointProperties> breakpoint) {
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        JavaScriptLineBreakpointProperties properties = (JavaScriptLineBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            final Ref result = Ref.create();
            final Integer myOrdinal = properties.lambdaOrdinal;
            if (myOrdinal != null) {
                PsiVisitors.visit((XSourcePosition)position, (Project)((XBreakpointBase)breakpoint).getProject(), (PsiVisitors.Visitor)new LambdaInLineVisitor(){

                    @Override
                    protected void process(@NotNull JSFunction element, @NotNull PsiElement firstBreakable) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$2", "process"));
                        }
                        if (firstBreakable == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBreakable", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$2", "process"));
                        }
                        if (myOrdinal == this.lambdaOrdinal) {
                            result.set((Object)element.getTextRange());
                            this.isStopped = true;
                        }
                        ++this.lambdaOrdinal;
                    }
                });
                return (TextRange)result.get();
            }
        }
        return null;
    }

    private class MyExactBreakpointVariant
    extends XLineBreakpointType.XLinePsiElementBreakpointVariant {
        private final int lambdaOrdinal;

        public MyExactBreakpointVariant(XSourcePosition lambdaPosition, PsiElement element, int lambdaOrdinal) {
            super((XLineBreakpointType)JavaScriptBreakpointType.this, lambdaPosition, element);
            this.lambdaOrdinal = lambdaOrdinal;
        }

        @Nullable
        public JavaScriptLineBreakpointProperties createProperties() {
            JavaScriptLineBreakpointProperties properties = (JavaScriptLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.lambdaOrdinal = this.lambdaOrdinal;
            return properties;
        }
    }

    private static class SpecifyRemoteUrlAction
    extends AnAction {
        private final JavaScriptDebugProcess<?> myDebugProcess;
        private final VirtualFile myFile;

        private SpecifyRemoteUrlAction(@NotNull JavaScriptDebugProcess debugProcess, @NotNull VirtualFile file) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$SpecifyRemoteUrlAction", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointType$SpecifyRemoteUrlAction", "<init>"));
            }
            super(JSDebuggerBundle.message("action.name.specify.remote.url.for.0", file.getName()));
            this.myDebugProcess = debugProcess;
            this.myFile = file;
        }

        public void actionPerformed(AnActionEvent e) {
            RemoteUrlMappingHelper.showSetRemoteUrlDialog(this.myDebugProcess, this.myFile);
        }
    }
}

