/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.util;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedProperties
extends Properties {
    private final Set<Object> myKeys = ContainerUtil.newLinkedHashSet();

    @NotNull
    public static OrderedProperties fromMap(@NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/osgi/jps/util/OrderedProperties", "fromMap"));
        }
        OrderedProperties result = new OrderedProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        OrderedProperties orderedProperties = result;
        if (orderedProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/util/OrderedProperties", "fromMap"));
        }
        return orderedProperties;
    }

    @NotNull
    public Map<String, String> toMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.size());
        for (String name : this.stringPropertyNames()) {
            result.put(name, this.getProperty(name));
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/util/OrderedProperties", "toMap"));
        }
        return linkedHashMap;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.myKeys);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this.myKeys);
    }

    @Override
    public Set<String> stringPropertyNames() {
        return Collections.unmodifiableSet(this.myKeys);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.myKeys.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.myKeys.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.myKeys.clear();
        super.clear();
    }
}

