/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingBundleInfoProvider {
    private static final Map<String, Pair<Long, Manifest>> ourCache = new WeakHashMap<String, Pair<Long, Manifest>>();

    public static boolean isBundle(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "isBundle"));
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-SymbolicName") != null;
    }

    public static boolean canBeBundlified(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "canBeBundlified"));
        }
        return path.endsWith(".jar") && new File(path).isFile() && !CachingBundleInfoProvider.isBundle(path);
    }

    @Nullable
    public static String getBundleSymbolicName(@NotNull String path) {
        int p;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "getBundleSymbolicName"));
        }
        String symbolicName = CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-SymbolicName");
        if (symbolicName != null && (p = symbolicName.indexOf(59)) > 0) {
            symbolicName = symbolicName.substring(0, p);
        }
        return symbolicName;
    }

    @Nullable
    public static String getBundleVersion(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "getBundleVersion"));
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Bundle-Version");
    }

    public static boolean isFragmentBundle(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "isFragmentBundle"));
        }
        return CachingBundleInfoProvider.getBundleAttribute(path, "Fragment-Host") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized String getBundleAttribute(@NotNull String path, @NotNull String attribute) {
        Pair pair;
        block13: {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "getBundleAttribute"));
            }
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/osgi/jps/build/CachingBundleInfoProvider", "getBundleAttribute"));
            }
            pair = ourCache.remove(path);
            try {
                File bundleFile = new File(path);
                if (bundleFile.isDirectory()) {
                    File manifestFile = new File(bundleFile, "META-INF/MANIFEST.MF");
                    if (pair != null && ((Long)pair.first).longValue() == manifestFile.lastModified()) break block13;
                    pair = null;
                    FileInputStream stream = new FileInputStream(manifestFile);
                    try {
                        Manifest manifest = new Manifest(stream);
                        pair = Pair.create((Object)manifestFile.lastModified(), (Object)manifest);
                        break block13;
                    }
                    finally {
                        stream.close();
                    }
                }
                if (!bundleFile.isFile() || pair != null && ((Long)pair.first).longValue() == bundleFile.lastModified()) break block13;
                pair = null;
                JarFile jar = new JarFile(bundleFile);
                try {
                    Manifest manifest = jar.getManifest();
                    if (manifest != null) {
                        pair = Pair.create((Object)bundleFile.lastModified(), (Object)manifest);
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (IOException e) {
                Logger.getInstance(CachingBundleInfoProvider.class).debug((Throwable)e);
            }
        }
        if (pair != null) {
            ourCache.put(path, pair);
            return ((Manifest)pair.second).getMainAttributes().getValue(attribute);
        }
        return null;
    }
}

