/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import java.text.DecimalFormat;
import java.util.Arrays;

public class Utils {
    private static DecimalFormat df = new DecimalFormat("0.0#####");

    static int max(float[] array) {
        int max = 0;
        float val = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(val < array[i])) continue;
            max = i;
            val = array[i];
        }
        return max;
    }

    static float max(float[][] array, int[] result) {
        int max1 = 0;
        int max2 = 0;
        float val = array[max1][max2];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                if (!(val < array[i][j])) continue;
                max1 = i;
                max2 = j;
                val = array[max1][max2];
            }
        }
        result[0] = max1;
        result[1] = max2;
        return val;
    }

    static String toS(float[] a) {
        String s = "[";
        if (a == null) {
            return "[null]";
        }
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                s = s + " , ";
            }
            String t = df.format(a[i]) + "       ";
            s = s + t.substring(0, 7);
        }
        s = s + "]";
        return s;
    }

    static String leftTrim(String str, int len) {
        return str.substring(str.length() - len);
    }

    static void zero(float[][] array) {
        for (float[] aFloat : array) {
            Arrays.fill(aFloat, -1.0f);
        }
    }

    public static int gaps(int[] start, int[] end) {
        Arrays.sort(start);
        Arrays.sort(end);
        int overlap = 0;
        int gaps = 0;
        int i = 0;
        int j = 0;
        while (j < end.length) {
            if (i < start.length && start[i] < end[j]) {
                ++overlap;
                ++i;
            } else {
                ++j;
                --overlap;
            }
            if (overlap != 0) continue;
            ++gaps;
        }
        return gaps;
    }

    public static int[] cells(int[] start, int[] end) {
        Arrays.sort(start);
        Arrays.sort(end);
        int overlap = 0;
        int gaps = 0;
        int i = 0;
        int j = 0;
        while (j < end.length) {
            if (i < start.length && start[i] < end[j]) {
                ++overlap;
                ++i;
            } else {
                ++j;
                --overlap;
            }
            if (overlap != 0) continue;
            ++gaps;
        }
        int[] cells = new int[gaps * 2];
        overlap = 0;
        gaps = 0;
        int previousOverlap = 0;
        int i2 = 0;
        int j2 = 0;
        while (j2 < end.length) {
            if (i2 < start.length && start[i2] < end[j2]) {
                ++overlap;
                if (previousOverlap == 0) {
                    cells[gaps++] = start[i2];
                }
                ++i2;
            } else {
                if (--overlap == 0) {
                    cells[gaps++] = end[j2];
                }
                ++j2;
            }
            previousOverlap = overlap;
        }
        return cells;
    }

    public static int getPosition(int[] pos, int p1, int p2) {
        for (int j = 0; j < pos.length; j += 2) {
            if (pos[j] > p1 || p2 > pos[j + 1]) continue;
            return j / 2;
        }
        return -1;
    }

    static int[] sortUnique(int[] list) {
        Arrays.sort(list);
        int count = 1;
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == list[i - 1]) continue;
            ++count;
        }
        int[] ret = new int[count];
        count = 1;
        ret[0] = list[0];
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == list[i - 1]) continue;
            ret[count++] = list[i];
        }
        return ret;
    }

    static void fwPrint(String s, int size) {
        s = s + "                                             ";
        s = s.substring(0, size);
        System.out.print(s);
    }
}

