/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.tools.sherpa.scout.Direction;
import com.android.tools.sherpa.scout.ScoutProbabilities;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ScoutWidget
implements Comparable<ScoutWidget> {
    private static final boolean DEBUG = false;
    private static final float MAXIMUM_STRETCH_GAP = 0.6f;
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mBaseLine;
    private ScoutWidget mParent;
    private float mRootDistance;
    private float[] mDistToRootCache = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    ConstraintWidget mConstraintWidget;
    private boolean mKeepExistingConnections = true;
    private Rectangle mRectangle;
    static Comparator<ScoutWidget> sSortY = (w1, w2) -> w1.mConstraintWidget.getY() - w2.mConstraintWidget.getY();

    public ScoutWidget(ConstraintWidget constraintWidget, ScoutWidget parent) {
        this.mConstraintWidget = constraintWidget;
        this.mParent = parent;
        this.mX = constraintWidget.getX();
        this.mY = constraintWidget.getY();
        this.mWidth = constraintWidget.getWidth();
        this.mHeight = constraintWidget.getHeight();
        this.mBaseLine = this.mConstraintWidget.getBaselineDistance() + constraintWidget.getY();
        if (parent != null) {
            this.mRootDistance = ScoutWidget.distance(parent, this);
        }
    }

    @Override
    public int compareTo(ScoutWidget scoutWidget) {
        if (this.mParent == null) {
            return -1;
        }
        if (this.mRootDistance != scoutWidget.mRootDistance) {
            return Float.compare(this.mRootDistance, scoutWidget.mRootDistance);
        }
        if (this.mY != scoutWidget.mY) {
            return Float.compare(this.mY, scoutWidget.mY);
        }
        if (this.mX != scoutWidget.mX) {
            return Float.compare(this.mX, scoutWidget.mX);
        }
        return 0;
    }

    public String toString() {
        return this.mConstraintWidget.getDebugName();
    }

    boolean isRoot() {
        return this.mParent == null;
    }

    public boolean isGuideline() {
        return this.mConstraintWidget instanceof Guideline;
    }

    public boolean isVerticalGuideline() {
        if (this.mConstraintWidget instanceof Guideline) {
            Guideline g = (Guideline)this.mConstraintWidget;
            return g.getOrientation() == 1;
        }
        return false;
    }

    public boolean isHorizontalGuideline() {
        if (this.mConstraintWidget instanceof Guideline) {
            Guideline g = (Guideline)this.mConstraintWidget;
            return g.getOrientation() == 0;
        }
        return false;
    }

    public static ScoutWidget[] create(ConstraintWidget[] array) {
        ScoutWidget rootwidget;
        Object[] ret = new ScoutWidget[array.length];
        ConstraintWidget root = array[0];
        ret[0] = rootwidget = new ScoutWidget(root, null);
        int count = 1;
        for (int i = 0; i < ret.length; ++i) {
            if (array[i] == root) continue;
            ret[count++] = new ScoutWidget(array[i], rootwidget);
        }
        Arrays.sort(ret);
        return ret;
    }

    float getLocation(Direction dir) {
        switch (dir) {
            case NORTH: {
                return this.mY;
            }
            case SOUTH: {
                return this.mY + this.mHeight;
            }
            case WEST: {
                return this.mX;
            }
            case EAST: {
                return this.mX + this.mWidth;
            }
            case BASE: {
                return this.mBaseLine;
            }
        }
        return this.mBaseLine;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getWidth() {
        return this.mWidth;
    }

    final float getX() {
        return this.mX;
    }

    final float getY() {
        return this.mY;
    }

    public static void computeConstraints(ScoutWidget[] list) {
        ScoutProbabilities table = new ScoutProbabilities();
        table.computeConstraints(list);
        table.applyConstraints(list);
    }

    private static ConstraintAnchor.Type lookupType(int dir) {
        return ScoutWidget.lookupType(Direction.get(dir));
    }

    private static ConstraintAnchor.Type lookupType(Direction dir) {
        switch (dir) {
            case NORTH: {
                return ConstraintAnchor.Type.TOP;
            }
            case SOUTH: {
                return ConstraintAnchor.Type.BOTTOM;
            }
            case WEST: {
                return ConstraintAnchor.Type.LEFT;
            }
            case EAST: {
                return ConstraintAnchor.Type.RIGHT;
            }
            case BASE: {
                return ConstraintAnchor.Type.BASELINE;
            }
        }
        return ConstraintAnchor.Type.NONE;
    }

    boolean setCentered(int dir, ScoutWidget to1, ScoutWidget to2, Direction cDir1, Direction cDir2, float gap) {
        Direction ori = dir == 0 ? Direction.NORTH : Direction.WEST;
        ConstraintAnchor anchor1 = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(ori));
        ConstraintAnchor anchor2 = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(ori.getOpposite()));
        if (this.mKeepExistingConnections && (anchor1.isConnected() || anchor2.isConnected())) {
            if (anchor1.isConnected() ^ anchor2.isConnected()) {
                return false;
            }
            if (anchor1.isConnected() && anchor1.getTarget().getOwner() != to1.mConstraintWidget) {
                return false;
            }
            if (anchor2.isConnected() && anchor2.getTarget().getOwner() != to2.mConstraintWidget) {
                return false;
            }
        }
        if (anchor1.isConnectionAllowed(to1.mConstraintWidget) && anchor2.isConnectionAllowed(to2.mConstraintWidget)) {
            if (!this.isResizable(dir)) {
                float stretchRatio;
                if (dir == 0) {
                    int height = this.mConstraintWidget.getHeight();
                    stretchRatio = gap * 2.0f / (float)height;
                    if (this.isCandidateResizable(dir) && stretchRatio < 0.6f) {
                        this.mConstraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                    } else {
                        gap = 0.0f;
                    }
                } else {
                    int width = this.mConstraintWidget.getWidth();
                    stretchRatio = gap * 2.0f / (float)width;
                    if (this.isCandidateResizable(dir) && stretchRatio < 0.6f) {
                        this.mConstraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                    } else {
                        gap = 0.0f;
                    }
                }
            }
            if (to1.equals(to2)) {
                ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(cDir1), to1.mConstraintWidget, ScoutWidget.lookupType(cDir1), (int)gap);
                ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(cDir2), to2.mConstraintWidget, ScoutWidget.lookupType(cDir2), (int)gap);
            } else {
                float pos2;
                float pos1 = to1.getLocation(cDir1);
                Direction c1 = pos1 < (pos2 = to2.getLocation(cDir2)) ? ori : ori.getOpposite();
                Direction c2 = pos1 > pos2 ? ori : ori.getOpposite();
                int gap1 = ScoutWidget.gap(this.mConstraintWidget, c1, to1.mConstraintWidget, cDir1);
                int gap2 = ScoutWidget.gap(this.mConstraintWidget, c2, to2.mConstraintWidget, cDir2);
                ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(c1), to1.mConstraintWidget, ScoutWidget.lookupType(cDir1), Math.max(0, gap1));
                ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(c2), to2.mConstraintWidget, ScoutWidget.lookupType(cDir2), Math.max(0, gap2));
            }
            return true;
        }
        return false;
    }

    private static int gap(ConstraintWidget widget1, Direction direction1, ConstraintWidget widget2, Direction direction2) {
        switch (direction1) {
            case NORTH: 
            case WEST: {
                return ScoutWidget.getPos(widget1, direction1) - ScoutWidget.getPos(widget2, direction2);
            }
            case SOUTH: 
            case EAST: {
                return ScoutWidget.getPos(widget2, direction2) - ScoutWidget.getPos(widget1, direction1);
            }
        }
        return 0;
    }

    private static int getPos(ConstraintWidget widget, Direction direction) {
        switch (direction) {
            case NORTH: {
                return widget.getY();
            }
            case SOUTH: {
                return widget.getY() + widget.getHeight();
            }
            case WEST: {
                return widget.getX();
            }
            case EAST: {
                return widget.getX() + widget.getWidth();
            }
        }
        return 0;
    }

    boolean setEdgeCentered(int dir, ScoutWidget to1, Direction cDir1) {
        Direction ori = dir == 0 ? Direction.NORTH : Direction.WEST;
        ConstraintAnchor anchor1 = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(ori));
        ConstraintAnchor anchor2 = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(ori.getOpposite()));
        if (this.mKeepExistingConnections && (anchor1.isConnected() || anchor2.isConnected())) {
            if (anchor1.isConnected() ^ anchor2.isConnected()) {
                return false;
            }
            if (anchor1.isConnected() && anchor1.getTarget().getOwner() != to1.mConstraintWidget) {
                return false;
            }
        }
        if (anchor1.isConnectionAllowed(to1.mConstraintWidget)) {
            ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(ori), to1.mConstraintWidget, ScoutWidget.lookupType(cDir1), 0);
            ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(ori.getOpposite()), to1.mConstraintWidget, ScoutWidget.lookupType(cDir1), 0);
        }
        return true;
    }

    private static void connect(ConstraintWidget fromWidget, ConstraintAnchor.Type fromType, ConstraintWidget toWidget, ConstraintAnchor.Type toType, int gap) {
        fromWidget.connect(fromType, toWidget, toType, gap);
        fromWidget.getAnchor(fromType).setConnectionCreator(1);
    }

    private static void connectWeak(ConstraintWidget fromWidget, ConstraintAnchor.Type fromType, ConstraintWidget toWidget, ConstraintAnchor.Type toType, int gap) {
        fromWidget.connect(fromType, toWidget, toType, gap, ConstraintAnchor.Strength.WEAK);
        fromWidget.getAnchor(fromType).setConnectionCreator(1);
    }

    boolean setConstraint(int dir, ScoutWidget to, int cDir, float gap) {
        ConstraintAnchor.Type anchorType = ScoutWidget.lookupType(dir);
        if (to.isGuideline()) {
            cDir &= 2;
        }
        ConstraintAnchor anchor = this.mConstraintWidget.getAnchor(anchorType);
        if (this.mKeepExistingConnections) {
            if (anchor.isConnected()) {
                return anchor.getTarget().getOwner() == to.mConstraintWidget;
            }
            if (dir == Direction.BASE.getDirection()) {
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
                    return false;
                }
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.TOP).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.NORTH.getDirection()) {
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
                    return false;
                }
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.SOUTH.getDirection()) {
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.TOP).isConnected()) {
                    return false;
                }
                if (this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.WEST.getDirection() ? this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).isConnected() : dir == Direction.EAST.getDirection() && this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).isConnected()) {
                return false;
            }
        }
        if (anchor.isConnectionAllowed(to.mConstraintWidget)) {
            ScoutWidget.connect(this.mConstraintWidget, ScoutWidget.lookupType(dir), to.mConstraintWidget, ScoutWidget.lookupType(cDir), (int)gap);
            return true;
        }
        return false;
    }

    boolean setWeakConstraint(int dir, ScoutWidget to, int cDir) {
        ConstraintAnchor anchor = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(dir));
        float gap = 8.0f;
        if (this.mKeepExistingConnections && anchor.isConnected()) {
            return anchor.getTarget().getOwner() == to.mConstraintWidget;
        }
        if (anchor.isConnectionAllowed(to.mConstraintWidget)) {
            ScoutWidget.connectWeak(this.mConstraintWidget, ScoutWidget.lookupType(dir), to.mConstraintWidget, ScoutWidget.lookupType(cDir), (int)gap);
            return true;
        }
        return false;
    }

    static float distance(ScoutWidget a, ScoutWidget b) {
        float ax1 = a.mX;
        float ax2 = a.mX + a.mWidth;
        float ay1 = a.mY;
        float ay2 = a.mY + a.mHeight;
        float bx1 = b.mX;
        float bx2 = b.mX + b.mWidth;
        float by1 = b.mY;
        float by2 = b.mY + b.mHeight;
        float xdiff11 = Math.abs(ax1 - bx1);
        float xdiff12 = Math.abs(ax1 - bx2);
        float xdiff21 = Math.abs(ax2 - bx1);
        float xdiff22 = Math.abs(ax2 - bx2);
        float ydiff11 = Math.abs(ay1 - by1);
        float ydiff12 = Math.abs(ay1 - by2);
        float ydiff21 = Math.abs(ay2 - by1);
        float ydiff22 = Math.abs(ay2 - by2);
        float xmin = Math.min(Math.min(xdiff11, xdiff12), Math.min(xdiff21, xdiff22));
        float ymin = Math.min(Math.min(ydiff11, ydiff12), Math.min(ydiff21, ydiff22));
        boolean yOverlap = ay1 <= by2 && by1 <= ay2;
        boolean xOverlap = ax1 <= bx2 && bx1 <= ax2;
        float xReturn = yOverlap ? xmin : (float)Math.hypot(xmin, ymin);
        float yReturn = xOverlap ? ymin : (float)Math.hypot(xmin, ymin);
        return Math.min(xReturn, yReturn);
    }

    public ScoutWidget getParent() {
        return this.mParent;
    }

    public boolean isCandidateResizable(int dimension) {
        if (dimension == 0) {
            return this.mConstraintWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY || this.mConstraintWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mConstraintWidget.getHeight() > this.mConstraintWidget.getMinHeight();
        }
        return this.mConstraintWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY || this.mConstraintWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mConstraintWidget.getWidth() > this.mConstraintWidget.getMinWidth();
    }

    public boolean isResizable(int horizontal) {
        if (horizontal == 0) {
            return this.mConstraintWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY;
        }
        return this.mConstraintWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY;
    }

    public boolean hasBaseline() {
        return this.mConstraintWidget.hasBaseline();
    }

    public ScoutWidget getNeighbor(Direction dir, ScoutWidget[] list) {
        ScoutWidget neigh = list[0];
        float minDist = Float.MAX_VALUE;
        switch (dir) {
            case WEST: {
                float ay1 = this.getLocation(Direction.NORTH);
                float ay2 = this.getLocation(Direction.SOUTH);
                float ax = this.getLocation(Direction.WEST);
                for (int i = 1; i < list.length; ++i) {
                    float bx;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float by1 = iw.getLocation(Direction.NORTH);
                    float by2 = iw.getLocation(Direction.SOUTH);
                    if (!(Math.max(ay1, by1) <= Math.min(ay2, by2)) || !((bx = iw.getLocation(Direction.EAST)) < ax) || !(ax - bx < minDist)) continue;
                    minDist = ax - bx;
                    neigh = iw;
                }
                return neigh;
            }
            case EAST: {
                float ay1 = this.getLocation(Direction.NORTH);
                float ay2 = this.getLocation(Direction.SOUTH);
                float ax = this.getLocation(Direction.EAST);
                for (int i = 1; i < list.length; ++i) {
                    float bx;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float by1 = iw.getLocation(Direction.NORTH);
                    float by2 = iw.getLocation(Direction.SOUTH);
                    if (!(Math.max(ay1, by1) <= Math.min(ay2, by2)) || !((bx = iw.getLocation(Direction.WEST)) > ax) || !(bx - ax < minDist)) continue;
                    minDist = bx - ax;
                    neigh = iw;
                }
                return neigh;
            }
            case SOUTH: {
                float ax1 = this.getLocation(Direction.WEST);
                float ax2 = this.getLocation(Direction.EAST);
                float ay = this.getLocation(Direction.SOUTH);
                for (int i = 1; i < list.length; ++i) {
                    float by;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float bx1 = iw.getLocation(Direction.WEST);
                    float bx2 = iw.getLocation(Direction.EAST);
                    if (!(Math.max(ax1, bx1) <= Math.min(ax2, bx2)) || !((by = iw.getLocation(Direction.NORTH)) > ay) || !(by - ay < minDist)) continue;
                    minDist = by - ay;
                    neigh = iw;
                }
                return neigh;
            }
            case NORTH: {
                float ax1 = this.getLocation(Direction.WEST);
                float ax2 = this.getLocation(Direction.EAST);
                float ay = this.getLocation(Direction.NORTH);
                for (int i = 1; i < list.length; ++i) {
                    float by;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float bx1 = iw.getLocation(Direction.WEST);
                    float bx2 = iw.getLocation(Direction.EAST);
                    if (!(Math.max(ax1, bx1) <= Math.min(ax2, bx2)) || !(ay > (by = iw.getLocation(Direction.SOUTH))) || !(ay - by < minDist)) continue;
                    minDist = ay - by;
                    neigh = iw;
                }
                return neigh;
            }
        }
        return null;
    }

    public boolean isConnected(Direction direction) {
        return this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(direction)).isConnected();
    }

    private boolean isDistanceToRootCache(Direction direction) {
        int directionOrdinal = direction.getDirection();
        Float f = Float.valueOf(this.mDistToRootCache[directionOrdinal]);
        return !(f.floatValue() < 0.0f);
    }

    private void cacheRootDistance(Direction d, float value) {
        this.mDistToRootCache[d.getDirection()] = value;
    }

    public float connectedDistanceToRoot(ScoutWidget[] list, Direction direction) {
        float value = this.recursiveConnectedDistanceToRoot(list, direction);
        this.cacheRootDistance(direction, value);
        return value;
    }

    private float recursiveConnectedDistanceToRoot(ScoutWidget[] list, Direction direction) {
        if (this.isDistanceToRootCache(direction)) {
            return this.mDistToRootCache[direction.getDirection()];
        }
        ConstraintAnchor.Type anchorType = ScoutWidget.lookupType(direction);
        ConstraintAnchor anchor = this.mConstraintWidget.getAnchor(anchorType);
        if (anchor == null || !anchor.isConnected()) {
            return Float.NaN;
        }
        float margin = anchor.getMargin();
        ConstraintAnchor toAnchor = anchor.getTarget();
        ConstraintWidget toWidget = toAnchor.getOwner();
        if (list[0].mConstraintWidget == toWidget) {
            return margin;
        }
        if (toAnchor.getType() == anchorType) {
            for (ScoutWidget scoutWidget : list) {
                if (scoutWidget.mConstraintWidget != toWidget) continue;
                float dist = scoutWidget.recursiveConnectedDistanceToRoot(list, direction);
                scoutWidget.cacheRootDistance(direction, dist);
                return margin + dist;
            }
        }
        if (toAnchor.getType() == ScoutWidget.lookupType(direction.getOpposite())) {
            for (ScoutWidget scoutWidget : list) {
                if (scoutWidget.mConstraintWidget != toWidget) continue;
                float dist = scoutWidget.recursiveConnectedDistanceToRoot(list, direction);
                scoutWidget.cacheRootDistance(direction, dist);
                return (margin += scoutWidget.getLength(direction)) + dist;
            }
        }
        return Float.NaN;
    }

    private float getLength(Direction direction) {
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return this.mHeight;
            }
            case WEST: 
            case EAST: {
                return this.mWidth;
            }
        }
        return 0.0f;
    }

    public boolean isCentered(int orientationVertical) {
        if (this.isGuideline()) {
            return false;
        }
        if (orientationVertical == 0) {
            return this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.TOP).isConnected() && this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected();
        }
        return this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).isConnected() && this.mConstraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).isConnected();
    }

    public boolean hasConnection(Direction dir) {
        ConstraintAnchor anchor = this.mConstraintWidget.getAnchor(ScoutWidget.lookupType(dir));
        return anchor != null && anchor.isConnected();
    }

    public Rectangle getRectangle() {
        if (this.mRectangle == null) {
            this.mRectangle = new Rectangle();
        }
        this.mRectangle.x = this.mConstraintWidget.getX();
        this.mRectangle.y = this.mConstraintWidget.getY();
        this.mRectangle.width = this.mConstraintWidget.getWidth();
        this.mRectangle.height = this.mConstraintWidget.getHeight();
        return this.mRectangle;
    }

    static ScoutWidget[] getWidgetArray(WidgetContainer base) {
        ArrayList<WidgetContainer> list = new ArrayList<WidgetContainer>(base.getChildren());
        list.add(0, base);
        return ScoutWidget.create(list.toArray(new ConstraintWidget[list.size()]));
    }

    public int gap(Direction direction, ScoutWidget[] list) {
        int rootWidth = list[0].mConstraintWidget.getWidth();
        int rootHeight = list[0].mConstraintWidget.getHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case NORTH: {
                rect.y = 0;
                rect.x = this.mConstraintWidget.getX() + 1;
                rect.width = this.mConstraintWidget.getWidth() - 2;
                rect.height = this.mConstraintWidget.getY();
                break;
            }
            case SOUTH: {
                rect.y = this.mConstraintWidget.getY() + this.mConstraintWidget.getHeight();
                rect.x = this.mConstraintWidget.getX() + 1;
                rect.width = this.mConstraintWidget.getWidth() - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case WEST: {
                rect.y = this.mConstraintWidget.getY() + 1;
                rect.x = 0;
                rect.width = this.mConstraintWidget.getX();
                rect.height = this.mConstraintWidget.getHeight() - 2;
                break;
            }
            case EAST: {
                rect.y = this.mConstraintWidget.getY() + 1;
                rect.x = this.mConstraintWidget.getX() + this.mConstraintWidget.getWidth();
                rect.width = rootWidth - rect.x;
                rect.height = this.mConstraintWidget.getHeight() - 2;
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < list.length; ++i) {
            int dist;
            Rectangle r;
            ScoutWidget scoutWidget = list[i];
            if (scoutWidget == this || !(r = scoutWidget.getRectangle()).intersects(rect) || min <= (dist = (int)ScoutWidget.distance(scoutWidget, this))) continue;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            switch (direction) {
                case NORTH: {
                    return this.mConstraintWidget.getY();
                }
                case SOUTH: {
                    return rootHeight - (this.mConstraintWidget.getY() + this.mConstraintWidget.getHeight());
                }
                case WEST: {
                    return this.mConstraintWidget.getX();
                }
                case EAST: {
                    return rootWidth - (this.mConstraintWidget.getX() + this.mConstraintWidget.getWidth());
                }
            }
        }
        return min;
    }

    public void setX(int x) {
        this.mConstraintWidget.setX(x);
        this.mX = this.mConstraintWidget.getX();
    }

    public void setY(int y) {
        this.mConstraintWidget.setY(y);
        this.mY = this.mConstraintWidget.getY();
    }

    public void setWidth(int width) {
        this.mConstraintWidget.setWidth(width);
        this.mWidth = this.mConstraintWidget.getWidth();
    }

    public void setHeight(int height) {
        this.mConstraintWidget.setHeight(height);
        this.mHeight = this.mConstraintWidget.getHeight();
    }

    public int rootDistanceY() {
        if (this.mConstraintWidget == null || this.mConstraintWidget.getParent() == null) {
            return 0;
        }
        int rootHeight = this.mConstraintWidget.getParent().getHeight();
        int aY = this.mConstraintWidget.getY();
        int aHeight = this.mConstraintWidget.getHeight();
        return Math.min(aY, rootHeight - (aY + aHeight));
    }
}

