/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

public enum Direction {
    NORTH(0),
    SOUTH(1),
    WEST(2),
    EAST(3),
    BASE(4);

    private final int mDirection;
    static final int ORIENTATION_VERTICAL = 0;
    static final int ORIENTATION_HORIZONTAL = 1;
    private static Direction[] sAllDirections;
    private static Direction[] sVertical;
    private static Direction[] sHorizontal;

    private Direction(int n2) {
        this.mDirection = n2;
    }

    static Direction[] getAllDirections() {
        return sAllDirections;
    }

    static String toString(int directionInteger) {
        return Direction.get(directionInteger).toString();
    }

    public String toString() {
        switch (this) {
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case EAST: {
                return "E";
            }
            case WEST: {
                return "W";
            }
            case BASE: {
                return "B";
            }
        }
        return "?";
    }

    int getDirection() {
        return this.mDirection;
    }

    Direction getOpposite() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return NORTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
            case BASE: {
                return BASE;
            }
        }
        return BASE;
    }

    static Direction get(int directionInteger) {
        return sAllDirections[directionInteger];
    }

    boolean reverse() {
        return this == NORTH || this == WEST;
    }

    static Direction[] getDirections(int orientation) {
        if (orientation == 0) {
            return sVertical;
        }
        return sHorizontal;
    }

    public int connectTypes() {
        switch (this) {
            case NORTH: 
            case SOUTH: {
                return 2;
            }
            case EAST: 
            case WEST: {
                return 2;
            }
            case BASE: {
                return 1;
            }
        }
        return 1;
    }

    static {
        sAllDirections = Direction.values();
        sVertical = new Direction[]{NORTH, SOUTH, BASE};
        sHorizontal = new Direction[]{WEST, EAST};
    }
}

