/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.drawing;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintTableLayout;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ConnectionDraw;
import com.android.tools.sherpa.drawing.SnapDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.EnumSet;

public class WidgetDraw {
    private static final boolean DEBUG = false;
    static final int ZIGZAG = 2;
    static final int CENTER_ZIGZAG = 3;
    public static final long TOOLTIP_DELAY = 800L;
    private static final int GUIDDELINE_ICON_SIZE = 16;
    private static final int GUIDELINE_ARROW_SIZE = 6;
    private static final int ARROW_SIDE = 10;
    private static Polygon sVerticalGuidelineHandle;
    private static Polygon sHorizontalGuidelineHandle;
    public static Image sGuidelinePercent;
    public static Image sGuidelineArrowLeft;
    public static Image sGuidelineArrowRight;
    public static Image sGuidelineArrowUp;
    public static Image sGuidelineArrowDown;
    private static final Stroke sLineShadowStroke;
    private static final Stroke sBasicStroke;
    private static final Polygon sTooltipTriangleDown;
    private static final Polygon sTooltipTriangleUp;
    private static final int sArrowBase = 3;
    private static final int sArrowHeight = 3;

    public static void drawWidgetFrame(ViewTransform transform, Graphics2D g, ConstraintWidget widget, EnumSet<ANCHORS_DISPLAY> showAnchors, boolean showResizeHandles, boolean showSizeIndicator, boolean isSelected) {
        boolean showBaselineAnchor;
        boolean displayAllAnchors;
        boolean centerAnchorIsConnected;
        g.setStroke(SnapDraw.sNormalStroke);
        int l = transform.getSwingX(widget.getDrawX());
        int t = transform.getSwingY(widget.getDrawY());
        int w = transform.getSwingDimension(widget.getDrawWidth());
        int h = transform.getSwingDimension(widget.getDrawHeight());
        int r = transform.getSwingX(widget.getDrawX() + widget.getDrawWidth());
        int b = transform.getSwingY(widget.getDrawY() + widget.getDrawHeight());
        int radius = ConnectionDraw.CONNECTION_ANCHOR_SIZE;
        int radiusRect = 4;
        int rectDimension = radiusRect * 2;
        int midX = transform.getSwingX((int)((float)widget.getDrawX() + (float)widget.getDrawWidth() / 2.0f));
        int midY = transform.getSwingY((int)((float)widget.getDrawY() + (float)widget.getDrawHeight() / 2.0f));
        if (widget.getParent() instanceof ConstraintWidgetContainer) {
            ConstraintWidgetContainer parent = (ConstraintWidgetContainer)widget.getParent();
            if (widget instanceof Guideline) {
                if (parent.isRootContainer()) {
                    WidgetDraw.drawRootGuideline(transform, g, parent, (Guideline)widget, isSelected);
                }
                return;
            }
        }
        if (widget.getVisibility() == 4) {
            g.setStroke(SnapDraw.sDashedStroke);
        }
        ConstraintAnchor leftAnchor = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor rightAnchor = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor topAnchor = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottomAnchor = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        boolean leftAnchorIsConnected = leftAnchor.isConnected();
        boolean rightAnchorIsConnected = rightAnchor.isConnected();
        boolean topAnchorIsConnected = topAnchor.isConnected();
        boolean bottomAnchorIsConnected = bottomAnchor.isConnected();
        boolean baselineAnchorIsConnected = widget.getAnchor(ConstraintAnchor.Type.BASELINE).isConnected();
        boolean bl = centerAnchorIsConnected = leftAnchorIsConnected && rightAnchorIsConnected && leftAnchor.getTarget() == rightAnchor.getTarget() || topAnchorIsConnected && bottomAnchorIsConnected && topAnchor.getTarget() == bottomAnchor.getTarget();
        if (showResizeHandles) {
            g.fillRect(l - radiusRect, t - radiusRect, rectDimension, rectDimension);
            g.fillRect(r - radiusRect, t - radiusRect, rectDimension, rectDimension);
            g.fillRect(l - radiusRect, b - radiusRect, rectDimension, rectDimension);
            g.fillRect(r - radiusRect, b - radiusRect, rectDimension, rectDimension);
            if (showSizeIndicator) {
                ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(widget.getWidth()), l, r, t - 20);
                ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(widget.getHeight()), l - 20, t, b);
            }
        }
        boolean showLeftAnchor = (displayAllAnchors = showAnchors.contains((Object)ANCHORS_DISPLAY.ALL)) || showAnchors.contains((Object)ANCHORS_DISPLAY.LEFT) || showAnchors.contains((Object)ANCHORS_DISPLAY.HORIZONTAL);
        boolean showRightAnchor = displayAllAnchors || showAnchors.contains((Object)ANCHORS_DISPLAY.RIGHT) || showAnchors.contains((Object)ANCHORS_DISPLAY.HORIZONTAL);
        boolean showTopAnchor = displayAllAnchors || showAnchors.contains((Object)ANCHORS_DISPLAY.TOP) || showAnchors.contains((Object)ANCHORS_DISPLAY.VERTICAL);
        boolean showBottomAnchor = displayAllAnchors || showAnchors.contains((Object)ANCHORS_DISPLAY.BOTTOM) || showAnchors.contains((Object)ANCHORS_DISPLAY.VERTICAL);
        boolean showCenterAnchor = displayAllAnchors || showAnchors.contains((Object)ANCHORS_DISPLAY.CENTER);
        boolean bl2 = showBaselineAnchor = displayAllAnchors || showAnchors.contains((Object)ANCHORS_DISPLAY.BASELINE);
        if (!showAnchors.contains((Object)ANCHORS_DISPLAY.NONE) && showAnchors.contains((Object)ANCHORS_DISPLAY.CONNECTED)) {
            showLeftAnchor |= leftAnchorIsConnected;
            showRightAnchor |= rightAnchorIsConnected;
            showTopAnchor |= topAnchorIsConnected;
            showBottomAnchor |= bottomAnchorIsConnected;
            showCenterAnchor |= centerAnchorIsConnected;
            showBaselineAnchor |= baselineAnchorIsConnected;
        }
        if (showBaselineAnchor && !(widget instanceof ConstraintWidgetContainer) && widget.getBaselineDistance() > 0) {
            int baselineY = transform.getSwingY(WidgetInteractionTargets.constraintHandle(widget.getAnchor(ConstraintAnchor.Type.BASELINE)).getDrawY());
            g.drawLine(l, baselineY, r, baselineY);
        }
        boolean horizontalSpring = widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY;
        boolean verticalSpring = widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.ANY;
        Graphics2D g2 = (Graphics2D)g.create();
        if (widget instanceof ConstraintWidgetContainer) {
            g2.setStroke(SnapDraw.sLongDashedStroke);
            if (widget instanceof ConstraintTableLayout) {
                WidgetDraw.drawTableLayoutGuidelines(transform, g2, (ConstraintTableLayout)widget);
            }
        }
        if (!widget.isRootContainer() && (horizontalSpring || verticalSpring)) {
            int x = l;
            int y = t;
            Stroke previousStroke = g.getStroke();
            if (baselineAnchorIsConnected) {
                g2.setStroke(ConnectionDraw.sSpreadDashedStroke);
            }
            if (horizontalSpring) {
                if (showTopAnchor) {
                    WidgetDraw.drawHorizontalZigZagLine(g2, l, midX - radius, t, 2, 0);
                    WidgetDraw.drawHorizontalZigZagLine(g2, midX + radius, r, t, 2, 0);
                } else {
                    WidgetDraw.drawHorizontalZigZagLine(g2, l, r, t, 2, 0);
                }
                if (showBottomAnchor) {
                    WidgetDraw.drawHorizontalZigZagLine(g2, l, midX - radius, b, -2, 0);
                    WidgetDraw.drawHorizontalZigZagLine(g2, midX + radius, r, b, -2, 0);
                } else {
                    WidgetDraw.drawHorizontalZigZagLine(g2, l, r, b, -2, 0);
                }
            } else {
                g2.drawLine(x, y, x + w, y);
                g2.drawLine(x, y + h, x + w, y + h);
            }
            g2.setStroke(previousStroke);
            if (verticalSpring) {
                if (showLeftAnchor) {
                    WidgetDraw.drawVerticalZigZagLine(g2, l, t, midY - radius, 2, 0);
                    WidgetDraw.drawVerticalZigZagLine(g2, l, midY + radius, b, 2, 0);
                } else {
                    WidgetDraw.drawVerticalZigZagLine(g2, l, t, b, 2, 0);
                }
                if (showRightAnchor) {
                    WidgetDraw.drawVerticalZigZagLine(g2, r, t, midY - radius, -2, 0);
                    WidgetDraw.drawVerticalZigZagLine(g2, r, midY + radius, b, -2, 0);
                } else {
                    WidgetDraw.drawVerticalZigZagLine(g2, r, t, b, -2, 0);
                }
            } else {
                g2.drawLine(x, y, x, y + h);
                g2.drawLine(x + w, y, x + w, y + h);
            }
        } else {
            Stroke previousStroke = g.getStroke();
            if (baselineAnchorIsConnected) {
                g2.setStroke(ConnectionDraw.sSpreadDashedStroke);
            }
            if (showTopAnchor) {
                g2.drawLine(l, t, midX - radius, t);
                g2.drawLine(midX + radius, t, r, t);
            } else {
                g2.drawLine(l, t, r, t);
            }
            if (showBottomAnchor) {
                g2.drawLine(l, b, midX - radius, b);
                g2.drawLine(midX + radius, b, r, b);
            } else {
                g2.drawLine(l, b, r, b);
            }
            g2.setStroke(previousStroke);
            if (showLeftAnchor) {
                g2.drawLine(l, t, l, midY - radius);
                g2.drawLine(l, midY + radius, l, b);
            } else {
                g2.drawLine(l, t, l, b);
            }
            if (showRightAnchor) {
                g2.drawLine(r, t, r, midY - radius);
                g2.drawLine(r, midY + radius, r, b);
            } else {
                g2.drawLine(r, t, r, b);
            }
        }
        g2.dispose();
        g.setStroke(SnapDraw.sNormalStroke);
    }

    private static void drawTableLayoutGuidelines(ViewTransform transform, Graphics2D g, ConstraintTableLayout table) {
        Graphics2D g2 = (Graphics2D)g.create();
        ArrayList vertical = table.getVerticalGuidelines();
        ArrayList horizontal = table.getHorizontalGuidelines();
        g2.setStroke(SnapDraw.sThinDashedStroke);
        int l = transform.getSwingX(table.getDrawX());
        int t = transform.getSwingY(table.getDrawY());
        int r = transform.getSwingX(table.getDrawX() + table.getDrawWidth());
        int b = transform.getSwingY(table.getDrawY() + table.getDrawHeight());
        for (ConstraintWidget v : vertical) {
            int x = transform.getSwingX(v.getX()) + l;
            g2.drawLine(x, t, x, b);
        }
        for (ConstraintWidget h : horizontal) {
            int y = transform.getSwingY(h.getY()) + t;
            g2.drawLine(l, y, r, y);
        }
        g2.dispose();
    }

    public static void drawTableControls(ViewTransform transform, Graphics2D g, ConstraintTableLayout table) {
        ArrayList vertical = table.getVerticalGuidelines();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(1.0f));
        int l = transform.getSwingX(table.getDrawX());
        int t = transform.getSwingY(table.getDrawY());
        g2.setFont(ConnectionDraw.sFont);
        g2.drawRect(l, t - 20 - 4, 20, 20);
        int column = 0;
        String align = table.getColumnAlignmentRepresentation(column++);
        g2.drawString(align, l + 5, t - 4 - 5);
        for (ConstraintWidget v : vertical) {
            int x = transform.getSwingX(v.getX()) + l;
            g2.drawRect(x, t - 20 - 4, 20, 20);
            align = table.getColumnAlignmentRepresentation(column++);
            g2.drawString(align, x + 5, t - 4 - 5);
        }
        g2.dispose();
    }

    private static void drawRootGuideline(ViewTransform transform, Graphics2D g, ConstraintWidgetContainer root, Guideline guideline, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(SnapDraw.sThinDashedStroke);
        int l = transform.getSwingX(root.getDrawX());
        int t = transform.getSwingY(root.getDrawY());
        int r = transform.getSwingX(root.getDrawX() + root.getWidth());
        int b = transform.getSwingY(root.getDrawY() + root.getHeight());
        g.setFont(ConnectionDraw.sFont);
        if (guideline.getOrientation() == 1) {
            int x = transform.getSwingX(guideline.getDrawX());
            g2.drawLine(x, t, x, b);
            int offset = 2;
            int circleSize = 9;
            Ellipse2D.Float circle = new Ellipse2D.Float(x - circleSize, t - 2 * circleSize - offset, 2 * circleSize, 2 * circleSize);
            g.fill(circle);
            int relative = guideline.getRelativeBehaviour();
            if (relative == 0) {
                int iconWidth = sGuidelinePercent.getWidth(null);
                int iconHeight = sGuidelinePercent.getHeight(null);
                g.drawImage(sGuidelinePercent, x - 8, t - 16 - 3, x + 8, t - 3, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    int percent = guideline.getX() * 100 / root.getWidth();
                    ConnectionDraw.drawCircledText(g, ConnectionDraw.sFont, String.valueOf(percent), x, t + 20);
                }
            } else if (relative == 1) {
                int iconWidth = sGuidelineArrowLeft.getWidth(null);
                int iconHeight = sGuidelineArrowLeft.getHeight(null);
                int ty = t - 5 - offset / 2;
                g.drawImage(sGuidelineArrowLeft, x - 8, t - 16 - 3, x + 8, t - 3, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(guideline.getX()), l, x, ty + 20);
                }
            } else if (relative == 2) {
                int iconWidth = sGuidelineArrowRight.getWidth(null);
                int iconHeight = sGuidelineArrowRight.getHeight(null);
                int ty = t - 5 - offset / 2;
                g.drawImage(sGuidelineArrowRight, x - 8 + 1, t - 16 - 3, x + 8, t - 3, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    ConnectionDraw.drawHorizontalMarginIndicator(g, String.valueOf(root.getWidth() - guideline.getX()), x, r, ty + 20);
                }
            }
        } else {
            int y = transform.getSwingY(guideline.getDrawY());
            g2.drawLine(l, y, r, y);
            int offset = 2;
            int circleSize = 9;
            Ellipse2D.Float circle = new Ellipse2D.Float(l - 2 * circleSize - offset, y - circleSize, 2 * circleSize, 2 * circleSize);
            g.fill(circle);
            int relative = guideline.getRelativeBehaviour();
            if (relative == 0) {
                int iconWidth = sGuidelinePercent.getWidth(null);
                int iconHeight = sGuidelinePercent.getHeight(null);
                g.drawImage(sGuidelinePercent, l - 16 - 3, y - 8, l - 3, y + 8, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    int percent = guideline.getY() * 100 / root.getHeight();
                    ConnectionDraw.drawCircledText(g, ConnectionDraw.sFont, String.valueOf(percent), l + 20, y);
                }
            } else if (relative == 1) {
                int iconWidth = sGuidelineArrowUp.getWidth(null);
                int iconHeight = sGuidelineArrowUp.getHeight(null);
                g.drawImage(sGuidelineArrowUp, l - 16 - 3, y - 8, l - 3, y + 8, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(guideline.getY()), l + 20, t, y);
                }
            } else if (relative == 2) {
                int iconWidth = sGuidelineArrowDown.getWidth(null);
                int iconHeight = sGuidelineArrowDown.getHeight(null);
                Polygon arrow = ConnectionDraw.getBottomArrow();
                g.drawImage(sGuidelineArrowDown, l - 16 - 3, y - 8 + 1, l - 3, y + 8, 0, 0, iconWidth, iconHeight, null);
                if (isSelected) {
                    ConnectionDraw.drawVerticalMarginIndicator(g, String.valueOf(root.getHeight() - guideline.getY()), l + 20, y, b);
                }
            }
        }
        g2.dispose();
    }

    public static void drawWidgetInfo(ViewTransform transform, Graphics2D g, ConstraintWidget widget) {
        String debugName = widget.getDebugName();
        if (debugName != null) {
            int l = transform.getSwingX(widget.getDrawX());
            int t = transform.getSwingY(widget.getDrawY());
            int w = transform.getSwingDimension(widget.getDrawWidth());
            int h = transform.getSwingDimension(widget.getDrawHeight());
            int b = transform.getSwingY(widget.getDrawY() + widget.getDrawHeight());
            Graphics2D g2 = (Graphics2D)g.create();
            g2.clipRect(l, t, w, h);
            g2.drawString(debugName, l + 2, b - 2);
            g2.dispose();
        }
    }

    public static void drawResizeHandleSelection(ViewTransform transform, Graphics2D g, ResizeHandle selectedResizeHandle) {
        Rectangle bounds = selectedResizeHandle.getSwingBounds(transform);
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public static void drawHorizontalZigZagLine(Graphics2D g, int x1, int x2, int y) {
        WidgetDraw.drawHorizontalZigZagLine(g, x1, x2, y, 3, 3);
    }

    static void drawHorizontalZigZagLine(Graphics2D g, int x1, int x2, int y, int dY1, int dY2) {
        if (x2 < x1) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        int distance = x2 - x1;
        int step = 4 + (dY2 > 0 ? 2 : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int x = x1 + remainings / 2;
        g.drawLine(x1, y, x, y);
        for (int i = 0; i < count; ++i) {
            g.drawLine(x, y, x + 2, y + dY1);
            g.drawLine(x + 2, y + dY1, x + 4, y - dY2);
            if (dY2 != 0) {
                g.drawLine(x + 4, y - dY2, x + 6, y);
            }
            x += step;
        }
        g.drawLine(x, y, x2, y);
    }

    public static void drawVerticalZigZagLine(Graphics2D g, int x, int y1, int y2) {
        WidgetDraw.drawVerticalZigZagLine(g, x, y1, y2, 3, 3);
    }

    static void drawVerticalZigZagLine(Graphics2D g, int x, int y1, int y2, int dX1, int dX2) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int distance = y2 - y1;
        int step = 4 + (dX2 > 0 ? 2 : 0);
        int count = distance / step - 2;
        int remainings = distance - count * step;
        int y = y1 + remainings / 2;
        g.drawLine(x, y1, x, y);
        for (int i = 0; i < count; ++i) {
            g.drawLine(x, y, x + dX1, y + 2);
            g.drawLine(x + dX1, y + 2, x - dX2, y + 4);
            if (dX2 != 0) {
                g.drawLine(x - dX2, y + 4, x, y + 6);
            }
            y += step;
        }
        g.drawLine(x, y, x, y2);
    }

    private static Polygon getVerticalGuidelineHandle() {
        if (sVerticalGuidelineHandle == null) {
            sVerticalGuidelineHandle = new Polygon();
            sVerticalGuidelineHandle.addPoint(0, 0);
            sVerticalGuidelineHandle.addPoint(-6, -10);
            sVerticalGuidelineHandle.addPoint(6, -10);
        }
        return sVerticalGuidelineHandle;
    }

    private static Polygon getHorizontalGuidelineHandle() {
        if (sHorizontalGuidelineHandle == null) {
            sHorizontalGuidelineHandle = new Polygon();
            sHorizontalGuidelineHandle.addPoint(0, 0);
            sHorizontalGuidelineHandle.addPoint(-10, -6);
            sHorizontalGuidelineHandle.addPoint(-10, 6);
        }
        return sHorizontalGuidelineHandle;
    }

    public static void drawTooltip(Graphics2D g, ColorSet colorSet, String[] lines, int x, int y, boolean above) {
        if (lines == null) {
            return;
        }
        Font prefont = g.getFont();
        Color precolor = g.getColor();
        Stroke prestroke = g.getStroke();
        g.setFont(ConnectionDraw.sFont);
        FontMetrics fm = g.getFontMetrics(ConnectionDraw.sFont);
        int offset = 12;
        int margin = 2;
        int padding = 5;
        int textWidth = 0;
        int textHeight = 2 * padding;
        for (String line : lines) {
            textWidth = Math.max(textWidth, fm.stringWidth(line));
            int th = (int)fm.getStringBounds(line, g).getHeight();
            textHeight += th + margin;
        }
        textWidth += 2 * padding;
        int rectX = x - offset;
        int rectY = y - (textHeight -= margin) - 6 - offset;
        if (!above) {
            rectY = y + offset + 6;
        }
        Polygon triangle = sTooltipTriangleDown;
        int triangleY = rectY + textHeight;
        if (!above) {
            triangle = sTooltipTriangleUp;
            triangleY = rectY;
        }
        g.setColor(colorSet.getBackground());
        g.setStroke(sLineShadowStroke);
        triangle.translate(x, triangleY);
        g.fillPolygon(triangle);
        g.draw(triangle);
        triangle.translate(-x, -triangleY);
        g.fillRoundRect(rectX, rectY, textWidth, textHeight, 2, 2);
        g.drawRoundRect(rectX, rectY, textWidth, textHeight, 2, 2);
        g.setColor(colorSet.getTooltipBackground());
        g.setStroke(sBasicStroke);
        triangle.translate(x, triangleY);
        g.fillPolygon(triangle);
        g.draw(triangle);
        triangle.translate(-x, -triangleY);
        g.fillRoundRect(rectX, rectY, textWidth, textHeight, 2, 2);
        g.drawRoundRect(rectX, rectY, textWidth, textHeight, 2, 2);
        int ty = rectY + padding;
        for (int i = 0; i < lines.length; ++i) {
            int tw = fm.stringWidth(lines[i]);
            int tx = rectX + textWidth / 2 - tw / 2;
            g.setColor(colorSet.getTooltipText());
            g.drawString(lines[i], tx, ty + fm.getMaxAscent());
            ty = (int)((double)ty + (fm.getStringBounds(lines[i], g).getHeight() + (double)margin));
        }
        g.setFont(prefont);
        g.setColor(precolor);
        g.setStroke(prestroke);
    }

    static {
        sGuidelinePercent = null;
        sGuidelineArrowLeft = null;
        sGuidelineArrowRight = null;
        sGuidelineArrowUp = null;
        sGuidelineArrowDown = null;
        sLineShadowStroke = new BasicStroke(5.0f);
        sBasicStroke = new BasicStroke(1.0f);
        sTooltipTriangleDown = new Polygon();
        sTooltipTriangleUp = new Polygon();
        sTooltipTriangleDown.addPoint(-3, 0);
        sTooltipTriangleDown.addPoint(0, 3);
        sTooltipTriangleDown.addPoint(3, 0);
        sTooltipTriangleUp.addPoint(-3, 0);
        sTooltipTriangleUp.addPoint(0, -3);
        sTooltipTriangleUp.addPoint(3, 0);
    }

    public static enum ANCHORS_DISPLAY {
        NONE,
        HORIZONTAL,
        VERTICAL,
        LEFT,
        RIGHT,
        BASELINE,
        TOP,
        BOTTOM,
        CENTER,
        CONNECTED,
        ALL,
        SELECTED;

    }
}

