/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import android.support.constraint.solver.widgets.Animator;
import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class AnimatedText
extends Animation {
    private final String mText;
    private final int mX;
    private final int mY;
    private Color mTextColor = Color.WHITE;
    private static Font sFont = new Font("Helvetica", 0, 12);
    private int mTextWidth;
    private int mTextHeight;

    public AnimatedText(String text, int x, int y) {
        this.mText = text;
        this.mX = x;
        this.mY = y;
        this.setDuration(1200);
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        this.mTextWidth = fm.stringWidth(this.mText);
        this.mTextHeight = fm.getMaxAscent() + fm.getMaxDescent();
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        int alpha = (int)Animator.EaseInOutinterpolator((double)this.getProgress(), (double)255.0, (double)0.0);
        Color color = new Color(this.mTextColor.getRed(), this.mTextColor.getGreen(), this.mTextColor.getBlue(), alpha);
        g.setColor(color);
        g.setFont(sFont);
        g.drawString(this.mText, this.mX - this.mTextWidth / 2, this.mY + this.mTextHeight);
    }
}

