/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import java.awt.Color;
import java.awt.Graphics2D;

public class AnimatedConnection
extends Animation {
    final ConstraintAnchor mAnchor;
    private final ColorSet mColorSet;
    protected Color mColor;
    private int mOriginalCreator;

    public AnimatedConnection(ColorSet colorSet, ConstraintAnchor anchor) {
        this.mAnchor = anchor;
        this.mColorSet = colorSet;
        this.mColor = colorSet.getSelectedConstraints();
        if (this.mAnchor.getConnectionCreator() == 1) {
            this.mColor = colorSet.getCreatedConstraints();
        }
        this.mOriginalCreator = this.mAnchor.getConnectionCreator();
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        double progress = this.getProgress();
        int alpha = this.getPulsatingAlpha(progress);
        Color highlight = new Color(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), alpha);
        g.setColor(highlight);
        ConstraintHandle sourceHandle = WidgetInteractionTargets.constraintHandle(this.mAnchor);
        ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(this.mAnchor.getTarget());
        if (sourceHandle != null && targetHandle != null && progress >= 0.05) {
            float p = (float)(progress * 2.0);
            if (p > 1.0f) {
                p = 1.0f;
            }
            sourceHandle.drawConnection(transform, g, this.mColorSet, true, false, this.mOriginalCreator, p);
        }
    }
}

