/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.annotators;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.data.SpringDataBundle;
import com.intellij.spring.data.model.jpa.xml.JpaRepositories;
import com.intellij.spring.data.model.jpa.xml.JpaRepository;
import com.intellij.spring.data.util.SpringDataUtil;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import icons.SpringApiIcons;
import icons.SpringDataIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataRepositoryAnnotator
extends RelatedItemLineMarkerProvider {
    @NonNls
    private static final String IMPL_POSTFIX = "Impl";

    public String getId() {
        return "SpringDataRepositoryAnnotator";
    }

    public String getName() {
        return "Repositories";
    }

    @Nullable
    public Icon getIcon() {
        return SpringDataIcons.SpringData;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (psiElement == null || !SpringDataUtil.hasSpringDataSupport(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        SpringJavaClassInfo info;
        List mappedBeans;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "collectNavigationMarkers"));
        }
        if (!(psiElement instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (SpringDataUtil.isRepository(psiClass) && !(mappedBeans = (info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass)).getStereotypeMappedBeans()).isEmpty()) {
            PsiClass customImplementation;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            Set configurationBeans = SpringJamUtils.getInstance().findStereotypeConfigurationBeans(SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass), mappedBeans, module);
            HashSet repositories = new HashSet();
            for (CommonModelElement configurationBean : configurationBeans) {
                if (!(configurationBean instanceof JpaRepositories)) continue;
                repositories.add((JpaRepositories)configurationBean);
            }
            if (!repositories.isEmpty() && (customImplementation = SpringDataRepositoryAnnotator.getCustomImplementation(psiClass, (Set<JpaRepositories>)repositories, SpringDataRepositoryAnnotator.getBeanNames(mappedBeans))) != null) {
                NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.ParentBeanGutter).setTargets((Object[])new PsiElement[]{customImplementation}).setTooltipText(SpringDataBundle.message("goto.custom.implementation.title", customImplementation.getQualifiedName()));
                result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiClass.getNameIdentifier()));
            }
        }
    }

    @NotNull
    private static Set<String> getBeanNames(List<JamSpringBeanPointer> mappedBeans) {
        HashSet names = new HashSet();
        for (JamSpringBeanPointer bean : mappedBeans) {
            names.add(bean.getName());
        }
        HashSet hashSet = names;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "getBeanNames"));
        }
        return hashSet;
    }

    @Nullable
    private static PsiClass getCustomImplementation(@NotNull PsiClass psiClass, @NotNull Set<JpaRepositories> repositorieses, Set<String> beanNames) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "getCustomImplementation"));
        }
        if (repositorieses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositorieses", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "getCustomImplementation"));
        }
        HashSet postfixes = new HashSet();
        for (JpaRepositories repositories : repositorieses) {
            for (JpaRepository jpaRepository : repositories.getRepositories()) {
                if (!beanNames.contains(jpaRepository.getBeanName())) continue;
                if (DomUtil.hasXml(jpaRepository.getCustomImplRef())) {
                    SpringBeanPointer ref = (SpringBeanPointer)jpaRepository.getCustomImplRef().getValue();
                    return ref != null ? ref.getBeanClass() : null;
                }
                return SpringDataRepositoryAnnotator.getImplClass(psiClass, SpringDataRepositoryAnnotator.getPostfix((GenericAttributeValue<String>)jpaRepository.getRepositoryImplPostfix()));
            }
            postfixes.add(SpringDataRepositoryAnnotator.getPostfix((GenericAttributeValue<String>)repositories.getRepositoryImplPostfix()));
        }
        for (String postfix : postfixes) {
            PsiClass implClass = SpringDataRepositoryAnnotator.getImplClass(psiClass, postfix);
            if (implClass == null) continue;
            return implClass;
        }
        return null;
    }

    private static String getPostfix(GenericAttributeValue<String> implPostfix) {
        String postfix = implPostfix.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)postfix)) {
            postfix = IMPL_POSTFIX;
        }
        return postfix;
    }

    @Nullable
    private static PsiClass getImplClass(@NotNull PsiClass psiClass, @NotNull String postfix) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "getImplClass"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfix", "com/intellij/spring/data/annotators/SpringDataRepositoryAnnotator", "getImplClass"));
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            Project project = psiClass.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName + postfix, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }
}

