/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleMethodSignature {
    @NotNull
    private final String methodName;
    @NotNull
    private final List<String> erasedParameterTypes;

    public SimpleMethodSignature(@NotNull String methodName, @NotNull List<String> erasedParameterTypes) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/spring/integration/util/SimpleMethodSignature", "<init>"));
        }
        if (erasedParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "erasedParameterTypes", "com/intellij/spring/integration/util/SimpleMethodSignature", "<init>"));
        }
        this.methodName = methodName;
        this.erasedParameterTypes = erasedParameterTypes;
    }

    @NotNull
    public static SimpleMethodSignature get(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/integration/util/SimpleMethodSignature", "get"));
        }
        String methodName = method.getName();
        List erasedParameterTypes = ContainerUtil.map((Object[])method.getHierarchicalMethodSignature().getErasedParameterTypes(), parameterType -> parameterType.getCanonicalText(true));
        SimpleMethodSignature simpleMethodSignature = new SimpleMethodSignature(methodName, erasedParameterTypes);
        if (simpleMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/util/SimpleMethodSignature", "get"));
        }
        return simpleMethodSignature;
    }

    @Nullable
    public static SimpleMethodSignature get(String text) {
        Pattern pattern = Pattern.compile("(\\w+)(\\((((\\w+\\.)*\\w+,)*(\\w+\\.)*\\w+)?\\))?");
        Matcher matcher = pattern.matcher(text = text.replace(" ", ""));
        if (matcher.matches()) {
            String types = matcher.group(3);
            return new SimpleMethodSignature(matcher.group(1), (List<String>)(types == null ? Collections.emptyList() : new SmartList((Object[])types.split(","))));
        }
        return null;
    }

    @NotNull
    public String getMethodName() {
        String string = this.methodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/util/SimpleMethodSignature", "getMethodName"));
        }
        return string;
    }

    @NotNull
    public List<String> getErasedParameterTypes() {
        List<String> list = this.erasedParameterTypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/util/SimpleMethodSignature", "getErasedParameterTypes"));
        }
        return list;
    }

    public String toString(boolean presentation) {
        StringBuilder result = new StringBuilder();
        result.append(this.methodName);
        if (!this.erasedParameterTypes.isEmpty()) {
            result.append("(");
            result.append(StringUtil.join(this.erasedParameterTypes, (String)(presentation ? ", " : ",")));
            result.append(")");
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

