/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.integration.model.xml.core.Chain;
import com.intellij.spring.integration.model.xml.core.ExpressionOrInnerEndpointDefinitionAware;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationDynamicDomExtender {
    private static void register(DomElement containerElement, DomExtensionsRegistrar registrar) {
        XmlTag[] tags = containerElement.getXmlTag().getSubTags();
        if (tags.length == 0) {
            return;
        }
        final DomFileElement fileElement = DomUtil.getFileElement((DomElement)containerElement);
        NotNullLazyValue<List<? extends DomCollectionChildDescription>> descriptions = new NotNullLazyValue<List<? extends DomCollectionChildDescription>>(){

            @NotNull
            protected List<? extends DomCollectionChildDescription> compute() {
                List list = fileElement.getRootElement().getGenericInfo().getCollectionChildrenDescriptions();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$1", "compute"));
                }
                return list;
            }
        };
        DomFileDescription fileDescription = fileElement.getFileDescription();
        DomManager domManager = DomManager.getDomManager((Project)fileElement.getFile().getProject());
        block0: for (XmlTag tag : tags) {
            if (domManager.getDomElement(tag) != null) continue;
            String tagLocalName = tag.getLocalName();
            for (DomCollectionChildDescription description : (List)descriptions.getValue()) {
                String tagNamespace;
                List allowedNamespaces;
                String namespaceKey;
                String name = description.getXmlElementName();
                if (!tagLocalName.equals(name) || (namespaceKey = description.getXmlName().getNamespaceKey()) == null || !(allowedNamespaces = fileDescription.getAllowedNamespaces(namespaceKey, fileElement.getFile())).contains(tagNamespace = tag.getNamespace())) continue;
                registrar.registerCollectionChildrenExtension(description.getXmlName(), description.getType());
                continue block0;
            }
        }
    }

    public static class _ExpressionOrInnerEndpointDefinitionAware
    extends DomExtender<ExpressionOrInnerEndpointDefinitionAware> {
        public void registerExtensions(@NotNull ExpressionOrInnerEndpointDefinitionAware aware, @NotNull DomExtensionsRegistrar registrar) {
            if (aware == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aware", "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_ExpressionOrInnerEndpointDefinitionAware", "registerExtensions"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_ExpressionOrInnerEndpointDefinitionAware", "registerExtensions"));
            }
            SpringIntegrationDynamicDomExtender.register(aware, registrar);
        }
    }

    public static class _Chain
    extends DomExtender<Chain> {
        public void registerExtensions(@NotNull Chain chain, @NotNull DomExtensionsRegistrar registrar) {
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_Chain", "registerExtensions"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_Chain", "registerExtensions"));
            }
            SpringIntegrationDynamicDomExtender.register(chain, registrar);
        }
    }
}

