/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTarget;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.integration.model.DefaultChannels;
import com.intellij.spring.integration.model.ImplicitInputChannel;
import com.intellij.spring.integration.model.xml.core.InputOutputChannelOwner;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanWithDefinition;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationInputChannelBeansProvider
extends CustomLocalComponentsDiscoverer {
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/integration/model/SpringIntegrationInputChannelBeansProvider", "getCustomComponents"));
        }
        if (!(model instanceof LocalXmlModel)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/SpringIntegrationInputChannelBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        Module module = model.getModule();
        if (!SpringIntegrationUtil.isSpringIntegrationUsed(module)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/SpringIntegrationInputChannelBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        LocalXmlModel localXmlModel = (LocalXmlModel)model;
        DomFileElement fileElement = localXmlModel.getRoot();
        if (fileElement == null) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/SpringIntegrationInputChannelBeansProvider", "getCustomComponents"));
            }
            return set;
        }
        Beans parentBeansElement = (Beans)fileElement.getRootElement();
        List inputOutputChannelOwners = DomUtil.getDefinedChildrenOfType((DomElement)parentBeansElement, InputOutputChannelOwner.class, (boolean)true, (boolean)false);
        HashSet<CommonSpringBean> beans = new HashSet<CommonSpringBean>(inputOutputChannelOwners.size());
        for (InputOutputChannelOwner owner : inputOutputChannelOwners) {
            PsiClass psiClass;
            String inputChannelName;
            GenericAttributeValue<SpringBeanPointer> inputChannel = owner.getInputChannel();
            if (!DomUtil.hasXml(inputChannel) || !StringUtil.isNotEmpty((String)inputChannel.getRawText()) || DefaultChannels.channels.contains(inputChannelName = inputChannel.getRawText()) || SpringModelSearchers.findBean((CommonSpringModel)localXmlModel, (String)inputChannelName) != null || (psiClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.channel.DirectChannel")) == null || inputChannel.getXmlAttributeValue() == null) continue;
            beans.add((CommonSpringBean)new SpringImplicitBeanWithDefinition(inputChannelName, psiClass, (CommonSpringBean)owner, (PsiTarget)new ImplicitInputChannel(inputChannel, inputChannel.getXmlAttributeValue())));
        }
        HashSet<CommonSpringBean> hashSet = beans;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/SpringIntegrationInputChannelBeansProvider", "getCustomComponents"));
        }
        return hashSet;
    }
}

