/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model;

import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitInputChannel
extends DelegatePsiTarget
implements PsiDeclaredTarget,
PomRenameableTarget {
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final GenericAttributeValue myAttributeValue;

    public ImplicitInputChannel(@NotNull GenericAttributeValue genericAttributeValue, @NotNull XmlAttributeValue xmlAttributeValue) {
        if (genericAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericAttributeValue", "com/intellij/spring/integration/model/ImplicitInputChannel", "<init>"));
        }
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/spring/integration/model/ImplicitInputChannel", "<init>"));
        }
        super((PsiElement)xmlAttributeValue);
        this.myAttributeValue = genericAttributeValue;
        this.myRange = new TextRange(1, xmlAttributeValue.getTextLength() - 1);
    }

    public boolean isWritable() {
        return this.getNavigationElement().isWritable();
    }

    public Object setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/spring/integration/model/ImplicitInputChannel", "setName"));
        }
        this.myAttributeValue.setStringValue(newName);
        return this.myAttributeValue.getParent();
    }

    public String getName() {
        return this.myAttributeValue.getStringValue();
    }

    @Nullable
    public TextRange getNameIdentifierRange() {
        return this.myRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImplicitInputChannel channel = (ImplicitInputChannel)((Object)o);
        return this.myAttributeValue.equals(channel.myAttributeValue);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAttributeValue.hashCode();
        return result;
    }
}

