/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.integration.model.xml.core.Channel;
import com.intellij.spring.integration.model.xml.core.InputOutputChannelOwner;
import com.intellij.spring.integration.model.xml.event.InboundChannelAdapter;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PayloadTypeProvider {
    PayloadTypeProvider() {
    }

    @NotNull
    static String resolvePayloadType(PsiElement context) {
        GenericAttributeValue<List<PsiType>> datatype;
        DomElement domElement = DomUtil.getDomElement((PsiElement)context.getParent());
        if (domElement == null) {
            if ("java.lang.Object" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/PayloadTypeProvider", "resolvePayloadType"));
            }
            return "java.lang.Object";
        }
        if (domElement instanceof InboundChannelAdapter) {
            Collection eventTypes = (Collection)((InboundChannelAdapter)domElement).getEventTypes().getValue();
            PsiClass eventTypePsiClass = (PsiClass)ContainerUtil.getFirstItem((Collection)eventTypes);
            String string = PayloadTypeProvider.determinePsiClassType(eventTypePsiClass);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/PayloadTypeProvider", "resolvePayloadType"));
            }
            return string;
        }
        Channel channel = PayloadTypeProvider.resolveChannel(domElement);
        if (channel != null && DomUtil.hasXml(datatype = channel.getDatatype())) {
            PsiType type = (PsiType)ContainerUtil.getFirstItem((List)((List)datatype.getValue()));
            PsiClass dataTypePsiClass = PsiTypesUtil.getPsiClass((PsiType)type);
            String string = PayloadTypeProvider.determinePsiClassType(dataTypePsiClass);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/PayloadTypeProvider", "resolvePayloadType"));
            }
            return string;
        }
        if ("java.lang.Object" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/PayloadTypeProvider", "resolvePayloadType"));
        }
        return "java.lang.Object";
    }

    @NotNull
    private static String determinePsiClassType(@Nullable PsiClass psiClass) {
        String string = StringUtil.notNullize((String)(psiClass != null ? psiClass.getQualifiedName() : null), (String)"java.lang.Object");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/PayloadTypeProvider", "determinePsiClassType"));
        }
        return string;
    }

    @Nullable
    private static Channel resolveChannel(DomElement domElement) {
        InputOutputChannelOwner inputOutputChannelOwner = (InputOutputChannelOwner)domElement.getParentOfType(InputOutputChannelOwner.class, true);
        if (inputOutputChannelOwner == null) {
            return null;
        }
        GenericAttributeValue<SpringBeanPointer> inputChannel = inputOutputChannelOwner.getInputChannel();
        if (!DomUtil.hasXml(inputChannel)) {
            return null;
        }
        SpringBeanPointer inputChannelPointer = (SpringBeanPointer)inputChannel.getValue();
        if (inputChannelPointer == null) {
            return null;
        }
        CommonSpringBean channelBean = inputChannelPointer.getSpringBean();
        if (!(channelBean instanceof Channel)) {
            return null;
        }
        return (Channel)channelBean;
    }
}

