/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetConverter
extends ResolvingConverter.StringConverter {
    private final AtomicNotNullLazyValue<Set<String>> charSets = new AtomicNotNullLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            Set set = ContainerUtil.map2Set((Object[])CharsetToolkit.getAvailableCharsets(), Charset::name);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/converters/CharsetConverter$1", "compute"));
            }
            return set;
        }
    };

    public String fromString(String s, ConvertContext convertContext) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return ((Set)this.charSets.getValue()).contains(s) ? s : null;
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        return LookupElementBuilder.create((String)s).withCaseSensitivity(false);
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext convertContext) {
        Collection collection = (Collection)this.charSets.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/converters/CharsetConverter", "getVariants"));
        }
        return collection;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return "Cannot resolve charset '" + s + "'";
    }
}

