/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;

public class ReloadMvcPluginListAction
extends AnAction
implements DumbAware {
    private final MvcPluginsMain myMvcPluginsMain;

    public ReloadMvcPluginListAction(MvcPluginsMain mvcPluginsMain) {
        super("Reload plugin list", "Reload plugin list", AllIcons.Actions.Refresh);
        this.myMvcPluginsMain = mvcPluginsMain;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = this.myMvcPluginsMain.getProject();
        if (GrailsConsole.getInstance(project).isExecuting()) {
            String frameworkName = "Grails";
            Messages.showErrorDialog((Project)project, (String)("Failed to reload plugin list: " + frameworkName + " Console is busy"), (String)("Can't execute " + frameworkName + " command"));
            return;
        }
        ReloadMvcPluginListAction.doReloadPluginList(this.myMvcPluginsMain);
    }

    public static void doReloadPluginList(@NotNull MvcPluginsMain mvcPlugins) {
        if (mvcPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mvcPlugins", "org/jetbrains/plugins/groovy/mvc/plugins/actions/ReloadMvcPluginListAction", "doReloadPluginList"));
        }
        assert (!GrailsConsole.getInstance(mvcPlugins.getProject()).isExecuting());
        GrailsCommandExecutorUtil.executeInModal(mvcPlugins.getApplication(), new MvcCommand("list-plugins", new String[0]), "Updating plugin list...", mvcPlugins::reloadPlugins, true);
    }
}

