/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;

public abstract class GrailsCachedValue<E extends UserDataHolder, R> {
    private final Key<CachedValue<R>> key = Key.create((String)this.toString());
    private final Key dependency;

    protected GrailsCachedValue() {
        this(PsiModificationTracker.MODIFICATION_COUNT);
    }

    protected GrailsCachedValue(Key dependency) {
        this.dependency = dependency;
    }

    public R get(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/GrailsCachedValue", "get"));
        }
        CachedValue cachedValue = (CachedValue)element.getUserData(this.key);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.getProject(element)).createCachedValue(() -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/util/GrailsCachedValue", "lambda$get$0"));
                }
                return CachedValueProvider.Result.create(this.calculate(element), (Object[])new Object[]{this.dependency});
            }, false);
            cachedValue = (CachedValue)((UserDataHolderEx)element).putUserDataIfAbsent(this.key, (Object)cachedValue);
        }
        return (R)cachedValue.getValue();
    }

    protected abstract Project getProject(E var1);

    protected abstract R calculate(E var1);
}

