/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

class GrailsArtifactCache {
    private final MultiMap<String, VirtualFile> myVirtualFileMap;
    private final PsiManager myManager;
    private long myModificationStamp = -1L;
    private volatile MultiMap<String, GrClassDefinition> myClassMap;

    GrailsArtifactCache(MultiMap<String, VirtualFile> virtualFileMap, Project project) {
        this.myVirtualFileMap = virtualFileMap;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    public MultiMap<String, VirtualFile> getVirtualFileMap() {
        return this.myVirtualFileMap;
    }

    @Nullable
    private GrClassDefinition getClassDefinition(@Nullable VirtualFile file) {
        GrTypeDefinition typeDefinition = GroovyUtils.getPublicClass((VirtualFile)file, (PsiManager)this.myManager);
        if (typeDefinition instanceof GrClassDefinition) {
            return (GrClassDefinition)typeDefinition;
        }
        return null;
    }

    @NotNull
    public List<GrClassDefinition> getClasses(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
        }
        if (this.myModificationStamp == this.myManager.getModificationTracker().getJavaStructureModificationCount()) {
            List list = (List)this.myClassMap.get((Object)artifactName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
            }
            return list;
        }
        List vfList = (List)this.myVirtualFileMap.get((Object)artifactName);
        if (vfList.isEmpty()) {
            List<GrClassDefinition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
            }
            return list;
        }
        List<GrClassDefinition> list = this.getClasses(vfList);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
        }
        return list;
    }

    @NotNull
    private List<GrClassDefinition> getClasses(@NotNull List<VirtualFile> vfList) {
        if (vfList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfList", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
        }
        int size = vfList.size();
        if (size == 1) {
            GrClassDefinition classDefinition = this.getClassDefinition(vfList.get(0));
            if (classDefinition == null) {
                List<GrClassDefinition> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
                }
                return list;
            }
            List<GrClassDefinition> list = Collections.singletonList(classDefinition);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
            }
            return list;
        }
        ArrayList<GrClassDefinition> list = new ArrayList<GrClassDefinition>(size);
        for (VirtualFile virtualFile : vfList) {
            ContainerUtil.addIfNotNull(list, (Object)this.getClassDefinition(virtualFile));
        }
        ArrayList<GrClassDefinition> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifactCache", "getClasses"));
        }
        return arrayList;
    }

    public MultiMap<String, GrClassDefinition> getClassesMap() {
        long modificationStamp = this.myManager.getModificationTracker().getJavaStructureModificationCount();
        if (this.myModificationStamp == modificationStamp) {
            return this.myClassMap;
        }
        MultiMap res = new MultiMap();
        for (Map.Entry entry : this.myVirtualFileMap.entrySet()) {
            List<GrClassDefinition> classes = this.getClasses((List)entry.getValue());
            if (classes.isEmpty()) continue;
            res.put(entry.getKey(), classes);
        }
        this.myClassMap = res;
        this.myModificationStamp = modificationStamp;
        return res;
    }
}

