/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class EditorComboBoxWithHistory
extends ComboBox {
    @NotNull
    private final String myDataKey;

    public EditorComboBoxWithHistory(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "<init>"));
        }
        super((ComboBoxModel)EditorComboBoxWithHistory.createModel(key));
        this.setEditor((ComboBoxEditor)new StringComboboxEditor(project, (FileType)PlainTextFileType.INSTANCE, (ComboBox)this));
        this.myDataKey = key;
    }

    @NotNull
    public EditorTextField getEditorComponent() {
        EditorTextField editorTextField = (EditorTextField)super.getEditor().getEditorComponent();
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "getEditorComponent"));
        }
        return editorTextField;
    }

    @NotNull
    public String getText() {
        String string = this.getEditorComponent().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "getText"));
        }
        return string;
    }

    public MyModel getModel() {
        return (MyModel)super.getModel();
    }

    public void save() {
        String text = this.getText();
        ArrayList<String> strings = new ArrayList<String>(this.getModel().myStrings);
        int index = strings.indexOf(text);
        if (index > -1) {
            strings.remove(index);
        }
        strings.add(0, text);
        PropertiesComponent.getInstance().setValue(this.myDataKey, StringUtil.join(strings, (String)"\n"));
    }

    @NotNull
    private static MyModel createModel(@NotNull String dataKey) {
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "createModel"));
        }
        String history = PropertiesComponent.getInstance().getValue(dataKey);
        MyModel myModel = history == null ? new MyModel() : new MyModel(Arrays.stream(history.split("\n")).filter(StringUtil::isNotEmpty).collect(Collectors.toList()));
        if (myModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/ui/EditorComboBoxWithHistory", "createModel"));
        }
        return myModel;
    }

    public static class MyModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private final List<String> myStrings = ContainerUtil.newArrayList();
        private String myCurrentString;

        public MyModel() {
        }

        public MyModel(Collection<String> strings) {
            this.myStrings.addAll(strings);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int oldIndex = this.myStrings.indexOf(this.myCurrentString);
            this.myCurrentString = String.valueOf(anItem);
            int newIndex = this.myStrings.indexOf(this.myCurrentString);
            this.fireContentsChanged(anItem, oldIndex, newIndex);
        }

        @Override
        public Object getSelectedItem() {
            return this.myCurrentString;
        }

        @Override
        public int getSize() {
            return this.myStrings.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myStrings.get(index);
        }
    }
}

