/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.tests.GrailsTestUtilsKt;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsTestUtils {
    public static final String TEST_FOR = "grails.test.mixin.TestFor";
    public static final String TEST_MIXIN = "grails.test.mixin.TestMixin";
    public static final String MOCK = "grails.test.mixin.Mock";
    private static final String[] TEST_SUFFIXES = new String[]{"Test", "Tests", "Spec", "Specification", "UnitTest", "UnitTests", "UnitSpec", "UnitSpecification", "IntegrationTest", "IntegrationTests", "IntegrationSpec", "IntegrationSpecification"};

    private GrailsTestUtils() {
    }

    public static Collection<PsiClass> getTestsForArtifact(@NotNull PsiClass psiClass, boolean searchTestForAnnotation) {
        PsiClass annotationClass;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/grails/tests/GrailsTestUtils", "getTestsForArtifact"));
        }
        GrailsApplication application = GrailsApplicationManager.findApplication((PsiElement)psiClass);
        if (application == null) {
            return Collections.emptyList();
        }
        if (application.getGrailsVersion().isAtLeast(Version.GRAILS_3_0)) {
            List result2 = ContainerUtil.newSmartList();
            GrailsTestUtilsKt.getTestsForArtifact(application, psiClass, result2);
            return result2;
        }
        VirtualFile testDir = application.getRoot().findChild("test");
        if (testDir == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope testDirScope = GlobalSearchScopesCore.directoryScope((Project)application.getProject(), (VirtualFile)testDir, (boolean)true);
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance((Project)application.getProject());
        String className = psiClass.getName();
        ArrayList<PsiClass> res = new ArrayList<PsiClass>();
        for (String suffix : TEST_SUFFIXES) {
            String testClassName = className + suffix;
            for (PsiClass testClass : shortNamesCache.getClassesByName(testClassName, testDirScope)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)TEST_FOR, (boolean)false) || !(testClassName + ".groovy").equals(testClass.getContainingFile().getOriginalFile().getName())) continue;
                res.add(testClass);
            }
        }
        if (searchTestForAnnotation && (annotationClass = JavaPsiFacade.getInstance((Project)application.getProject()).findClass(TEST_FOR, psiClass.getResolveScope())) != null) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)annotationClass, (SearchScope)testDirScope).findAll()) {
                PsiElement annotatedClass;
                PsiAnnotationOwner annotationOwner;
                PsiElement resolve;
                PsiAnnotationMemberValue value;
                PsiElement annotation;
                PsiElement element = reference.getElement();
                if (!(element instanceof GrCodeReferenceElement) || !((annotation = element.getParent()) instanceof GrAnnotation) || !((value = ((GrAnnotation)annotation).findDeclaredAttributeValue("value")) instanceof GrReferenceExpression) || (resolve = ((GrReferenceExpression)value).resolve()) != psiClass || !((annotationOwner = ((PsiAnnotation)annotation).getOwner()) instanceof PsiModifierList) || !((annotatedClass = ((PsiModifierList)annotationOwner).getParent()) instanceof GrClassDefinition)) continue;
                res.add((PsiClass)annotatedClass);
            }
        }
        return res;
    }

    @Nullable
    public static PsiClass getTestedClass(@NotNull PsiClass testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "org/jetbrains/plugins/grails/tests/GrailsTestUtils", "getTestedClass"));
        }
        if (!(testClass instanceof GrClassDefinition)) {
            return null;
        }
        if (!GrailsUtils.isInGrailsTests((PsiElement)testClass)) {
            return null;
        }
        PsiModifierList modifierList = testClass.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation annotation = modifierList.findAnnotation(TEST_FOR);
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
            if (!(value instanceof GrReferenceExpression)) {
                return null;
            }
            PsiElement resolve = ((GrReferenceExpression)value).resolve();
            if (!(resolve instanceof PsiClass)) {
                return null;
            }
            PsiClass aClass = (PsiClass)resolve;
            if (GrailsArtifact.getType(aClass) == null) {
                return null;
            }
            return aClass;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)testClass);
        if (module == null) {
            return null;
        }
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(module);
        if (appDir == null) {
            return null;
        }
        GlobalSearchScope appDirScope = GlobalSearchScopes.directoryScope((Project)module.getProject(), (VirtualFile)appDir, (boolean)true);
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance((Project)module.getProject());
        String testClassName = testClass.getName();
        for (String suffix : TEST_SUFFIXES) {
            if (!testClassName.endsWith(suffix)) continue;
            String artifactName = StringUtil.trimEnd((String)testClassName, (String)suffix);
            for (PsiClass artifact : shortNamesCache.getClassesByName(artifactName, appDirScope)) {
                if (GrailsArtifact.getType(artifact) == null) continue;
                return artifact;
            }
        }
        return null;
    }

    @Nullable
    public static String getTestType(@NotNull PsiClass testClass) {
        if (testClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "org/jetbrains/plugins/grails/tests/GrailsTestUtils", "getTestType"));
        }
        VirtualFile virtualFile = testClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)testClass.getProject()).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
        if (sourceRoot == null) {
            return null;
        }
        VirtualFile parent = sourceRoot.getParent();
        if (parent == null || !parent.getName().equals("test")) {
            return null;
        }
        return sourceRoot.getName();
    }

    public static PsiType getTestedClassClass(GrReferenceExpression ref) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
        PsiClass classClass = facade.findClass("java.lang.Class", ref.getResolveScope());
        if (classClass == null) {
            return null;
        }
        PsiType testedClass = GrailsTestUtils.getTestedClass(ref);
        if (testedClass != null) {
            return facade.getElementFactory().createType(classClass, testedClass);
        }
        return facade.getElementFactory().createType(classClass);
    }

    @Nullable
    public static PsiType getTestedClass(GrReferenceExpression ref) {
        PsiClass testClass = PsiUtil.getContainingNotInnerClass((PsiElement)ref);
        if (testClass == null) {
            return null;
        }
        String testClassName = testClass.getQualifiedName();
        if (testClassName == null) {
            return null;
        }
        String testedClassName = GrailsTestUtils.getTestedClassName(testClassName);
        if (testedClassName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)testClass.getProject());
        PsiClass testedClass = facade.findClass(testedClassName, testClass.getResolveScope());
        if (testedClass == null) {
            return null;
        }
        return facade.getElementFactory().createType(testedClass);
    }

    @Nullable
    public static String getTestedClassName(String testClassName) {
        int suffixIndex = Math.max(testClassName.lastIndexOf("Controller"), testClassName.lastIndexOf("TagLib"));
        if (suffixIndex == -1) {
            return null;
        }
        int testedClassNameLength = suffixIndex + (testClassName.charAt(suffixIndex) == 'C' ? "Controller".length() : "TagLib".length());
        if (testClassName.indexOf(46, testedClassNameLength) != -1) {
            return null;
        }
        return testClassName.substring(0, testedClassNameLength);
    }
}

