/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class InjectedSpringBeanProvider
extends GrVariableEnhancer {
    public static boolean isSupportInjection(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/grails/spring/InjectedSpringBeanProvider", "isSupportInjection"));
        }
        return GrailsUtils.isBootStrapClass(aClass) || GrailsArtifact.getType(aClass) != null || GrailsUtils.isInGrailsTests((PsiElement)aClass) || GrailsUtils.isCommandClass(aClass);
    }

    @Nullable
    public static SpringBeanPointer getInjectedBean(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/grails/spring/InjectedSpringBeanProvider", "getInjectedBean"));
        }
        if (!(variable instanceof GrField) || !((GrField)variable).isProperty()) {
            return null;
        }
        PsiType declaredType = ((GrField)variable).getDeclaredType();
        if (declaredType != null && !(declaredType instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((GrField)variable).getContainingClass();
        if (aClass == null || !InjectedSpringBeanProvider.isSupportInjection(aClass)) {
            return null;
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)aClass);
        SpringBeanPointer springBean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)variable.getName());
        if (springBean == null) {
            return null;
        }
        if (declaredType != null && !InjectedSpringBeanProvider.beanCanBeAssignedTo(springBean, declaredType)) {
            return null;
        }
        return springBean;
    }

    private static boolean beanCanBeAssignedTo(SpringBeanPointer springBean, PsiType variableType) {
        PsiType[] type = springBean.getEffectiveBeanTypes();
        if (type.length == 0) {
            return true;
        }
        for (PsiType psiType : type) {
            if (!psiType.isAssignableFrom(variableType) && !variableType.isAssignableFrom(psiType)) continue;
            return true;
        }
        return false;
    }

    public PsiType getVariableType(GrVariable variable) {
        if (variable.getDeclaredType() != null) {
            return null;
        }
        SpringBeanPointer bean = InjectedSpringBeanProvider.getInjectedBean((PsiVariable)variable);
        if (bean != null) {
            return TypesUtil.getLeastUpperBound((PsiType[])bean.getEffectiveBeanTypes(), (PsiManager)variable.getManager());
        }
        return null;
    }
}

