/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsWebApplicationContextMembersContributor
extends NonCodeMembersContributor {
    public String getParentClassName() {
        return "org.springframework.context.ApplicationContext";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/grails/spring/GrailsWebApplicationContextMembersContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/spring/GrailsWebApplicationContextMembersContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/spring/GrailsWebApplicationContextMembersContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/spring/GrailsWebApplicationContextMembersContributor", "processDynamicElements"));
        }
        if (!ResolveUtil.shouldProcessProperties((ElementClassHint)((ElementClassHint)processor.getHint(ElementClassHint.KEY)))) {
            return;
        }
        GrailsStructure structure = GrailsStructure.getInstance(place);
        if (structure == null) {
            return;
        }
        Module module = structure.getModule();
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        PsiManager manager = structure.getManager();
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (nameHint == null) {
            for (SpringBeanPointer pointer : model.getAllCommonBeans()) {
                if (!pointer.isValid()) continue;
                PsiType type = TypesUtil.getLeastUpperBound((PsiType[])pointer.getEffectiveBeanTypes(), (PsiManager)manager);
                PsiElement psiElement = pointer.getPsiElement();
                if (psiElement == null || processor.execute((PsiElement)new GrLightVariable(manager, pointer.getName(), type, psiElement), state)) continue;
                return;
            }
        } else {
            SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)nameHint);
            if (bean != null && bean.isValid()) {
                PsiType type = TypesUtil.getLeastUpperBound((PsiType[])bean.getEffectiveBeanTypes(), (PsiManager)manager);
                PsiElement psiElement = bean.getPsiElement();
                if (psiElement != null && !processor.execute((PsiElement)new GrLightVariable(manager, nameHint, type, psiElement), state)) {
                    return;
                }
            }
        }
    }
}

