/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class GrailsBackgroundService {
    private final BackgroundTaskQueue myQueue;

    public GrailsBackgroundService(Project project) {
        this.myQueue = new BackgroundTaskQueue(project, "Grails background tasks");
    }

    public void run(Task.Backgroundable task) {
        this.myQueue.run(task);
    }

    @NotNull
    public static GrailsBackgroundService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/service/GrailsBackgroundService", "getInstance"));
        }
        GrailsBackgroundService grailsBackgroundService = (GrailsBackgroundService)ServiceManager.getService((Project)project, GrailsBackgroundService.class);
        if (grailsBackgroundService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/service/GrailsBackgroundService", "getInstance"));
        }
        return grailsBackgroundService;
    }
}

