/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public class GrailsConfigurationFactory
extends ConfigurationFactory {
    public GrailsConfigurationFactory(ConfigurationType configurationType) {
        super(configurationType);
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/runner/GrailsConfigurationFactory", "createTemplateConfiguration"));
        }
        GrailsRunConfiguration grailsRunConfiguration = new GrailsRunConfiguration(project, this, "Grails");
        if (grailsRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsConfigurationFactory", "createTemplateConfiguration"));
        }
        return grailsRunConfiguration;
    }

    public boolean isConfigurationSingletonByDefault() {
        return true;
    }

    public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
        if (providerID == CompileStepBeforeRun.ID || providerID == CompileStepBeforeRunNoErrorCheck.ID) {
            task.setEnabled(false);
        }
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/runner/GrailsConfigurationFactory", "isApplicable"));
        }
        return GrailsApplicationManager.getInstance(project).hasApplications();
    }
}

