/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GrailsFileReferenceSetBase;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GspIncludeViewAttributeSupport
extends TagAttributeReferenceProvider {
    protected GspIncludeViewAttributeSupport() {
        super("view", "g", new String[]{"include"});
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspIncludeViewAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspIncludeViewAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspIncludeViewAttributeSupport", "getReferencesByElement"));
        }
        final VirtualFile viewsDirectory = GrailsUtils.findViewsDirectory(element);
        if (viewsDirectory == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspIncludeViewAttributeSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GrailsFileReferenceSetBase set = new GrailsFileReferenceSetBase(text, element, offset, null, true, true){

            @Override
            protected VirtualFile getDefaultContext(boolean isAbsolute) {
                return viewsDirectory;
            }
        };
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspIncludeViewAttributeSupport", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

