/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.other;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.TemplateFileReferenceSet;

public class GrailsTemplateNamedArgumentReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/other/GrailsTemplateNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/other/GrailsTemplateNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        TemplateFileReferenceSet set = new TemplateFileReferenceSet(null, trimedUrl, element, offset, null, true, true, null);
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/other/GrailsTemplateNamedArgumentReferenceProvider", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

