/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.criteria;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.criteria.CriteriaBuilderImplicitMemberContributor;
import org.jetbrains.plugins.grails.references.domain.criteria.CriteriaBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CriteriaReturnTypeCalculator
extends GrCallExpressionTypeCalculator {
    public PsiType calculateReturnType(@NotNull GrMethodCall callExpression, @Nullable PsiElement resolve) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/grails/references/domain/criteria/CriteriaReturnTypeCalculator", "calculateReturnType"));
        }
        GrExpression[] arguments = PsiUtil.getAllArguments((GrCall)callExpression);
        if (arguments.length == 0) {
            return null;
        }
        int i = 0;
        if (arguments[0] == null || GroovyPsiManager.isInheritorCached((PsiType)arguments[0].getType(), (String)"java.util.Map")) {
            ++i;
        }
        if (i != arguments.length - 1 || !(arguments[i] instanceof GrClosableBlock)) {
            return null;
        }
        GrClosableBlock closure = (GrClosableBlock)arguments[i];
        GrExpression invokedExpression = callExpression.getInvokedExpression();
        if (invokedExpression instanceof GrReferenceExpression && resolve instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            if (CriteriaBuilderImplicitMemberContributor.isMine(method)) {
                PsiType returnType = method.getReturnType();
                assert (returnType != null);
                boolean isList = returnType.equalsToText("java.util.List");
                if (!isList && !returnType.equalsToText("java.lang.Object")) {
                    return null;
                }
                PsiClass domainClass = CriteriaBuilderUtil.findDomainClassByMethodCall(callExpression, true);
                if (domainClass == null) {
                    return null;
                }
                return CriteriaReturnTypeCalculator.createType(isList, domainClass, closure);
            }
            if (GrLightMethodBuilder.checkKind((PsiElement)method, (Object)DomainDescriptor.DOMAIN_DYNAMIC_METHOD) && "withCriteria".equals(method.getName())) {
                PsiClass domainClass = (PsiClass)((GrLightMethodBuilder)method).getData();
                if (!GormUtils.isGormBean(domainClass)) {
                    return null;
                }
                assert (domainClass != null);
                boolean isList = true;
                for (GrNamedArgument namedArgument : PsiUtil.getFirstMapNamedArguments((GrCall)callExpression)) {
                    if (!"uniqueResult".equals(namedArgument.getLabelName())) continue;
                    GrExpression expression = namedArgument.getExpression();
                    if (!(expression instanceof GrLiteralImpl) || !Boolean.TRUE.equals(((GrLiteralImpl)expression).getValue())) break;
                    isList = false;
                    break;
                }
                return CriteriaReturnTypeCalculator.createType(isList, domainClass, closure);
            }
            return null;
        }
        if (!GroovyPsiManager.isInheritorCached((PsiType)invokedExpression.getType(), (String)"grails.orm.HibernateCriteriaBuilder")) {
            return null;
        }
        PsiClass domainClass = CriteriaBuilderUtil.findDomainClassByBuilderExpression(invokedExpression);
        if (domainClass == null) {
            return null;
        }
        return CriteriaReturnTypeCalculator.createType(true, domainClass, closure);
    }

    @Nullable
    private static PsiType createType(boolean isList, @NotNull PsiClass domainClass, @NotNull GrClosableBlock closure) {
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "org/jetbrains/plugins/grails/references/domain/criteria/CriteriaReturnTypeCalculator", "createType"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/grails/references/domain/criteria/CriteriaReturnTypeCalculator", "createType"));
        }
        PsiType elementType = CriteriaBuilderUtil.getResultType(domainClass, closure);
        if (!isList) {
            return elementType;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)domainClass.getProject());
        PsiClass listClass = facade.findClass("java.util.List", domainClass.getResolveScope());
        if (listClass == null) {
            return null;
        }
        return facade.getElementFactory().createType(listClass, elementType);
    }
}

